//=============================================================================
// VisuStella MZ - CG Gallery
// VisuMZ_4_CGGallery.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_4_CGGallery = true;

var VisuMZ = VisuMZ || {};
VisuMZ.CGGallery = VisuMZ.CGGallery || {};
VisuMZ.CGGallery.version = 1.00;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 4] [Version 1.00] [CGGallery]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/CG_Gallery_VisuStella_MZ
 * @base VisuMZ_0_CoreEngine
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * Does your game have a lot of pretty art? Especially pretty art that your
 * players would love to view again on their own? This plugin provides a new
 * scene called a CG Gallery for players to view art that they have encountered
 * on their game playthroughs. The CG Gallery allows you to separate art into
 * various categories where the player can view them individually, zooming in
 * and out and moving all about for that perfect angle.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Automatically unlock art listings for the CG Gallery through Show Picture
 *   event commands or unlock them manually through Plugin Commands.
 * * The Plugin Parameters allow you the ability to add categories, listings,
 *   and adjust various aspects of the CG Gallery.
 * * When art listings are unlocked, they will be visible across all saves and
 *   can be accessible through the title scene even.
 * * Art listings can be paired with text descriptions to explain what the art
 *   piece is all about and/or even provide credit to the artist that drew it.
 * * Art listings can have variants so that you can bundle up similar art
 *   pieces together without cluttering the entire CG Gallery.
 * * When viewing art listings, extra features are added to allow players to
 *   zoom in, zoom out, toggle the borders, move the picture about, and change
 *   between art variations.
 * * Completion Rates and Variant Counts are displayed in-game to let the
 *   player know about the progress made in completing the CG Gallery.
 * * Some art listings can be automatically unlocked by default as a form of
 *   bonus art, similar to what you see in many commercial Visual Novels.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 4 ------
 *
 * This plugin is a Tier 4 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * CG Gallery Storage
 * 
 * The CG Gallery unlock progress is stored in the configuration file. This is
 * primarily done so that the progress is readily accessible across all saves
 * and can be updated across all saves.
 *
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === CG Plugin Commands ===
 * 
 * ---
 *
 * CG: Unlock Image(s)
 * - Unlocks specific image(s) for the CG Gallery.
 *
 *   Filename(s):
 *   - List of filenames for CG's that will become unlocked.
 *
 *   Argument:
 *   - Description
 *
 *   Argument:
 *   - Description
 *
 *   Argument:
 *   - Description
 *
 *   Argument:
 *   - Description
 *
 * ---
 *
 * CG: Unlock All Images (Debug)
 * - Unlocks all image(s) for the CG Gallery.
 * - Only for playtesting. Resets upon game closing.
 *
 * ---
 *
 * CG: Unlock All Images (Permanent)
 * - Unlocks all image(s) for the CG Gallery.
 * - This is a permanent unlock.
 *
 * ---
 * 
 * CG: Reset All Unlocks (Permanent)
 * - Reset all unlocks for the CG Gallery.
 * - This is a permanent reset. Use SPARRINGLY!
 * 
 * ---
 * 
 * === Scene Plugin Commands ===
 * 
 * ---
 *
 * Scene: Open CG Gallery
 * - Opens CG Gallery.
 * - CANNOT be used inside of battle.
 *
 * ---
 * 
 * === System Plugin Commands ===
 * 
 * ---
 *
 * System: Enable CG Gallery in Menu?
 * - Enables/disables CG Gallery menu inside the main menu.
 *
 *   Enable/Disable?:
 *   - Enables/disables CG Gallery menu inside the main menu.
 *
 * ---
 *
 * System: Show CG Gallery in Menu?
 * - Shows/hides CG Gallery menu inside the main menu.
 *
 *   Show/Hide?:
 *   - Shows/hides CG Gallery menu inside the main menu.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Image Categories
 * ============================================================================
 *
 * List of categories that are used for this plugin. The order these categories
 * appear in the settings will be the order they're displayed in the gallery.
 *
 * ---
 *
 * Settings
 * 
 *   ID Key:
 *   - This category's identification key.
 *   - Categories require unique keys for the plugin to differentiate them.
 * 
 *   Text:
 *   - This category's command text.
 * 
 *   Icon:
 *   - Icon used for this category.
 *   - Use 0 for no icon.
 * 
 *   Help Description:
 *   - A description of the CG Gallery listing.
 *   - Text codes allowed.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Image Listing Settings
 * ============================================================================
 *
 * A listing of all the pictures found in the CG Gallery. The order these
 * images appear in the settings will be the order they're displayed in the
 * CG Gallery.
 *
 * ---
 *
 * Settings
 * 
 *   Filename:
 *   - Filename used for the CG Gallery listing.
 *   - This will be used as the CG Gallery thumbnail, too.
 * 
 *     Variations:
 *     - Variations of the CG Gallery listing.
 * 
 *   Category:
 *   - The category this image is listed under.
 *   - If unlisted, the image will be listed under "Unlisted".
 * 
 *   Help Description:
 *   - A description of the CG Gallery listing.
 *   - Text codes allowed.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Default Unlocks Settings
 * ============================================================================
 *
 * List of filenames for CG's that are already unlocked and viewable.
 *
 * ---
 * 
 * Settings
 * 
 *   Filename: 
 *   - Filename used for the default unlocked art listing.
 *   - Make sure the art listing is found inside Image Listings.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: System Settings
 * ============================================================================
 *
 * System settings for CG Gallery.
 *
 * ---
 *
 * Auto-Unlocks
 * 
 *   Show Picture?:
 *   - Auto-unlock listings for the CG Gallery when using "Show Picture"
 *     event commands?
 * 
 *   Variations?:
 *   - Auto-unlock variations for listings for the CG Gallery?
 * 
 * ---
 * 
 * Scene_CG_Gallery
 * 
 *   Move Distance:
 *   - How many pixels should pictures move per frame?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Main Menu Settings
 * ============================================================================
 *
 * Main Menu settings for CG Gallery.
 *
 * ---
 *
 * Main Menu Settings
 * 
 *   Command Name:
 *   - Name of the 'CG Gallery' option in the Main Menu.
 * 
 *   Show in Main Menu?:
 *   - Add the 'CG Gallery' option to the Main Menu by default?
 * 
 *   Enable in Main Menu?:
 *   - Enable the 'CG Gallery' option to the Main Menu by default?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Background Settings
 * ============================================================================
 *
 * Background settings for Scene_CG_Gallery.
 *
 * ---
 *
 * Background Settings
 * 
 *   Snapshop Opacity:
 *   - Snapshot opacity for the scene.
 * 
 *   Background 1:
 *   - Filename used for the bottom background image.
 *   - Leave empty if you don't wish to use one.
 * 
 *   Background 2:
 *   - Filename used for the upper background image.
 *   - Leave empty if you don't wish to use one.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Sound Settings
 * ============================================================================
 *
 * Sound settings for the CG Gallery.
 *
 * ---
 *
 * Select Image
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * Change Variation
 * 
 *   Filename:
 *   - Filename of the sound effect played.
 * 
 *   Volume:
 *   - Volume of the sound effect played.
 * 
 *   Pitch:
 *   - Pitch of the sound effect played.
 * 
 *   Pan:
 *   - Pan of the sound effect played.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Vocabulary Settings
 * ============================================================================
 *
 * These settings let you adjust the text displayed for this plugin.
 *
 * ---
 *
 * Special Categories
 * 
 *   "All" Command:
 *   "Unlisted" Command:
 *   - Text used for the special Categories.
 * 
 * ---
 * 
 * Help Descriptions
 * 
 *   "All" Category:
 *   "Unlisted" Category:
 *   - A description used for the special Categories.
 *   - Text codes allowed.
 * 
 *   Not Unlocked Image:
 *   - A description used for yet to be unlocked images.
 *   - Text codes allowed.
 * 
 * ---
 * 
 * Gallery Window > Variations
 * 
 *   Complete Text:
 *   - Text displayed for listings with complete unlocks.
 *   - Leave empty to not use.
 * 
 *   Text Format:
 *   - Text format for listings with variations left.
 *   - %1 - Percent, %2 - Unlocked, %3 - Total
 *
 * ---
 * 
 * Gallery Window > Completion
 * 
 *   Vocabulary:
 *   - Main vocabulary used for this text.
 * 
 *   Text Format:
 *   - Text format used for completion percentage.
 *   - %1 - Percent, %2 - Unlocked, %3 - Total
 *
 * ---
 * 
 * Gallery Window > Progress
 * 
 *   Vocabulary:
 *   - Main vocabulary used for this text.
 * 
 *   Text Format:
 *   - Text format used for progress unlocked.
 *   - %1 - Percent, %2 - Unlocked, %3 - Total
 *
 * ---
 * 
 * Button Assist Window
 * 
 *   Border:
 *   - Text used for toggling border and borderless.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Gallery:
 *   - Text used for returning back to the gallery.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Next Variation:
 *   - Text used for going to next variation.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Previous Variation:
 *   - Text used for going to previous variation.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Reset Zoom/Position:
 *   - Text used for resetting the zoom and position.
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Zoom Change:
 *   - Text used for changing the zoom scale.
 *   - Requires VisuMZ_0_CoreEngine!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Window Settings
 * ============================================================================
 *
 * Settings for all the windows inside the CG Gallery scene.
 *
 * ---
 *
 * Window_Help
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Window_CG_Category
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 *   Special Categories:
 * 
 *     Add All Command?:
 *     - Add the "All" command for the CG Gallery Category window.
 * 
 *       "All" Icon:
 *       - Icon used for the "All" Category.
 * 
 *     Show Unlisted?:
 *     - Show the "Unlisted" command for the CG Gallery Category window
 *       if applicable.
 * 
 *       "Unlisted" Icon:
 *       - Icon used for the "Unlisted" Category.
 * 
 *   Style:
 *   - How do you wish to draw commands for this window?
 *     - Text Only
 *     - Icon Only
 *     - Icon + Text
 *     - Automatic
 * 
 *   Text Align:
 *   - Text alignment for this window?
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Window_CG_Gallery
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 *   Custom Locked Image:
 *   - Custom picture graphic used for entries that have yet to be unlocked.
 * 
 *   Image Buffer:
 *   - How many pixels of buffer range should there be for selected images?
 * 
 *   Listing Background?:
 *   - Show the dark background for listings?
 * 
 *   Max Columns:
 *   - Max columns used for this window.
 * 
 *     Spacing:
 *     - Column spacing for this window.
 * 
 *   Max Rows:
 *   - Max rows used for this window.
 * 
 *     Spacing:
 *     - Row spacing for this window.
 * 
 *   Stagger:
 *   - How many pixels should the gallery entries stagger by?
 *   - This is the diagonal listing effect.
 * 
 *     Towards Left?:
 *     - Which direction should the stagger be going towards?
 * 
 *   Text:
 * 
 *     Variations:
 * 
 *       Show?:
 *       - Show variations on the gallery thumbnail?
 * 
 *       Display Singles?:
 *       - Show text on listings with no variations?
 * 
 *       Horz Text Align:
 *       Vert Text Align:
 *       - Horizontal/vertical alignment for this text?
 * 
 *     Completion:
 * 
 *       Show?:
 *       - Show this text?
 * 
 *       Decimal Places:
 *       - How many decimal places should the percentage value go to?
 * 
 *       Font Name:
 *       - What is the font family name (NOT filename) of the font?
 *       - Look up the name via Windows Font Preview.
 * 
 *         Font Size: Vocab:
 *         - What is the font size of the main vocabulary?
 * 
 *         Font Size: Value:
 *         - What is the font size of the main value?
 * 
 *       Offset:
 * 
 *         Angle:
 *         - What angle should this text be shown at?
 * 
 *         Offset X:
 *         - How many pixels to offset the x position?
 *         - Negative: left. Positive: right.
 * 
 *         Offset Y:
 *         - How many pixels to offset the y position?
 *         - Negative: up. Positive: down.
 * 
 *     Progress:
 * 
 *       Show?:
 *       - Show this text?
 * 
 *       Decimal Places:
 *       - How many decimal places should the percentage value go to?
 * 
 *       Font Name:
 *       - What is the font family name (NOT filename) of the font?
 *       - Look up the name via Windows Font Preview.
 * 
 *         Font Size: Vocab:
 *         - What is the font size of the main vocabulary?
 * 
 *         Font Size: Value:
 *         - What is the font size of the main value?
 * 
 *       Offset:
 * 
 *         Angle:
 *         - What angle should this text be shown at?
 * 
 *         Offset X:
 *         - How many pixels to offset the x position?
 *         - Negative: left. Positive: right.
 * 
 *         Offset Y:
 *         - How many pixels to offset the y position?
 *         - Negative: up. Positive: down.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 * 
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Irina
 * * Arisu
 * * Olivia
 * * Yanfly
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.00 Official Release Date: March 3, 2023
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Begin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CG_UnlockImages
 * @text CG: Unlock Image(s)
 * @desc Unlocks specific image(s) for the CG Gallery.
 * 
 * @arg Filename:arraystr
 * @text Filename(s)
 * @type file[]
 * @dir img/pictures/
 * @desc List of filenames for CG's that will become unlocked.
 * @default []
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CG_UnlockAllImagesDebug
 * @text CG: Unlock All Images (Debug)
 * @desc Unlocks all image(s) for the CG Gallery.
 * Only for playtesting. Resets upon game closing.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CG_UnlockAllImagesPerma
 * @text CG: Unlock All Images (Permanent)
 * @desc Unlocks all image(s) for the CG Gallery.
 * This is a permanent unlock.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command CG_ResetAllImagesPerma
 * @text CG: Reset All Unlocks (Permanent)
 * @desc Reset all unlocks for the CG Gallery.
 * This is a permanent reset. Use SPARRINGLY!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Scene
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SceneOpenCgGallery
 * @text Scene: Open CG Gallery
 * @desc Opens CG Gallery.
 * CANNOT be used inside of battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_System
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemEnableCGGalleryMenu
 * @text System: Enable CG Gallery in Menu?
 * @desc Enables/disables CG Gallery menu inside the main menu.
 *
 * @arg Enable:eval
 * @text Enable/Disable?
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enables/disables CG Gallery menu inside the main menu.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemShowCGGalleryMenu
 * @text System: Show CG Gallery in Menu?
 * @desc Shows/hides CG Gallery menu inside the main menu.
 *
 * @arg Show:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides CG Gallery menu inside the main menu.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_End
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param CGGallery
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 * 
 * @param Gallery
 * 
 * @param Categories:arraystruct
 * @text Image Categories
 * @parent Gallery
 * @type struct<Category>[]
 * @desc List of categories that are used for this plugin.
 * @default ["{\"Key:str\":\"CG\",\"Text:str\":\"CGs\",\"Icon:num\":\"309\",\"Description:json\":\"\\\"View major scenes found in the game!\\\"\"}","{\"Key:str\":\"Character\",\"Text:str\":\"Characters\",\"Icon:num\":\"310\",\"Description:json\":\"\\\"View character art found in the game!\\\"\"}","{\"Key:str\":\"Background\",\"Text:str\":\"Backgrounds\",\"Icon:num\":\"311\",\"Description:json\":\"\\\"View backgrounds found in the game!\\\"\"}","{\"Key:str\":\"Extra\",\"Text:str\":\"Extras\",\"Icon:num\":\"312\",\"Description:json\":\"\\\"View extra content!\\\"\"}"]
 * 
 * @param Listing:arraystruct
 * @text Image Listing
 * @parent Gallery
 * @type struct<Listing>[]
 * @desc A listing of all the pictures found in the CG Gallery.
 * @default ["{\"Filename:str\":\"Actor1_1\",\"Variations:arraystr\":\"[\\\"SF_Actor1_1\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A portrait of Reid.\\\\nHe is the main protagonist of RPG Maker MZ!\\\"\"}","{\"Filename:str\":\"Actor1_2\",\"Variations:arraystr\":\"[\\\"SF_Actor1_2\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"It's an image of Priscilla.\\\\nShe is Reid's female counterpart.\\\"\"}","{\"Filename:str\":\"Actor1_3\",\"Variations:arraystr\":\"[\\\"SF_Actor1_3\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"Here's a portrait of Gale.\\\\nHe's quite the brawler.\\\"\"}","{\"Filename:str\":\"Actor1_4\",\"Variations:arraystr\":\"[\\\"SF_Actor1_4\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"Michelle's portrait.\\\\nComplete with her cheerful smile!\\\"\"}","{\"Filename:str\":\"Actor1_5\",\"Variations:arraystr\":\"[\\\"SF_Actor1_5\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"Albert and his handsome face.\\\\nDon't you wish you could just punch him?\\\"\"}","{\"Filename:str\":\"Actor1_6\",\"Variations:arraystr\":\"[\\\"SF_Actor1_6\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"An adorable portrait of Kasey.\\\\nHer energetic smile heals people.\\\"\"}","{\"Filename:str\":\"Actor1_7\",\"Variations:arraystr\":\"[\\\"SF_Actor1_7\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A tired portrait of Eliot.\\\\nHe's just so sick of Reid's shenanigans.\\\"\"}","{\"Filename:str\":\"Actor1_8\",\"Variations:arraystr\":\"[\\\"SF_Actor1_8\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"Roza's nicely profiled portrait.\\\\nIf only we saw more of her.\\\"\"}","{\"Filename:str\":\"Actor2_1\",\"Variations:arraystr\":\"[\\\"SF_Actor2_1\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A character known as Actor2_1.\\\\nA shame we don't know their RPG Maker MZ name.\\\"\"}","{\"Filename:str\":\"Actor2_2\",\"Variations:arraystr\":\"[\\\"SF_Actor2_2\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A character known as Actor2_2.\\\\nA shame we don't know their RPG Maker MZ name.\\\"\"}","{\"Filename:str\":\"Actor2_3\",\"Variations:arraystr\":\"[\\\"SF_Actor2_3\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A character known as Actor2_3.\\\\nA shame we don't know their RPG Maker MZ name.\\\"\"}","{\"Filename:str\":\"Actor2_4\",\"Variations:arraystr\":\"[\\\"SF_Actor2_4\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A character known as Actor2_4.\\\\nA shame we don't know their RPG Maker MZ name.\\\"\"}","{\"Filename:str\":\"Actor2_5\",\"Variations:arraystr\":\"[\\\"SF_Actor2_5\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A character known as Actor2_5.\\\\nA shame we don't know their RPG Maker MZ name.\\\"\"}","{\"Filename:str\":\"Actor2_6\",\"Variations:arraystr\":\"[\\\"SF_Actor2_6\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A character known as Actor2_6.\\\\nA shame we don't know their RPG Maker MZ name.\\\"\"}","{\"Filename:str\":\"Actor2_7\",\"Variations:arraystr\":\"[\\\"SF_Actor2_7\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A character known as Actor2_7.\\\\nA shame we don't know their RPG Maker MZ name.\\\"\"}","{\"Filename:str\":\"Actor2_8\",\"Variations:arraystr\":\"[\\\"SF_Actor2_8\\\"]\",\"Category:str\":\"Character\",\"Description:json\":\"\\\"A character known as Actor2_8.\\\\nA shame we don't know their RPG Maker MZ name.\\\"\"}"]
 * 
 * @param DefaultUnlocked:arraystr
 * @text Default Unlocks
 * @parent Listing:arraystruct
 * @type file[]
 * @dir img/pictures/
 * @desc List of filenames for CG's that are already unlocked and viewable.
 * @default ["Actor1_1","Actor1_2","Actor1_3","Actor1_4","Actor1_5","Actor1_6","Actor1_7","Actor1_8"]
 * 
 * @param Scenes
 *
 * @param System:struct
 * @text System Settings
 * @parent Scenes
 * @type struct<System>
 * @desc System settings for CG Gallery.
 * @default {"AutoUnlocks":"","AutoUnlockShowPicture:eval":"true","AutoUnlockVariations:eval":"false","Scene_CG_Gallery":"","MoveDistance:num":"4"}
 *
 * @param MainMenu:struct
 * @text Main Menu Settings
 * @parent Scenes
 * @type struct<MainMenu>
 * @desc Main Menu settings for CG Gallery.
 * @default {"Name:str":"CG Gallery","ShowMainMenu:eval":"true","EnableMainMenu:eval":"true","ShowTitleCommand:eval":"true"}
 *
 * @param BgSettings:struct
 * @text Background Settings
 * @parent Scenes
 * @type struct<BgSettings>
 * @desc Background settings for Scene_CG_Gallery.
 * @default {"SnapshotOpacity:num":"192","BgFilename1:str":"","BgFilename2:str":""}
 *
 * @param Sound:struct
 * @text Sound Settings
 * @parent Scenes
 * @type struct<Sound>
 * @desc Sound settings for the CG Gallery.
 * @default {"View":"","viewName:str":"Book1","viewVolume:num":"90","viewPitch:num":"100","viewPan:num":"0","Change":"","changeName:str":"Book2","changeVolume:num":"90","changePitch:num":"100","changePan:num":"0"}
 *
 * @param Vocab:struct
 * @text Vocabulary Settings
 * @parent Scenes
 * @type struct<Vocab>
 * @desc These settings let you adjust the text displayed for this plugin.
 * @default {"CategoryWindowCommands":"","AllCommandText:str":"All","UnlistedCommandText:str":"Unlisted","HelpDesc":"","AllCommandDescription:json":"\"View all types of images for this gallery.\"","UnlistedCommandDescription:json":"\"These images do not have a category.\"","LockedHelpDescription:json":"\"You have not unlocked this image yet.\"","GalleryWindow":"","GalleryWindowVariations":"","GalleryWindow_Text_VariationComplete:str":"\\}★","GalleryWindow_Text_VariationFmt:str":"\\}%2/%3","GalleryWindowCompletion":"","GalleryWindow_Text_CompletionVocab:str":"Completion","GalleryWindow_Text_CompletionFmt:str":"%1%","GalleryWindowProgress":"","GalleryWindow_Text_ProgressVocab:str":"Progress","GalleryWindow_Text_ProgressFmt:str":"%2/%3","ButtonAssist":"","ButtonAssistVocab_Border:str":"Border","ButtonAssistVocab_Gallery:str":"Gallery","ButtonAssistVocab_Next:str":"Next","ButtonAssistVocab_Prev:str":"Prev","ButtonAssistVocab_Reset:str":"Reset","ButtonAssistVocab_Zoom:str":"Zoom"}
 * 
 * @param Window:struct
 * @text Window Settings
 * @parent Scenes
 * @type struct<Window>
 * @desc Settings for all the windows inside the CG Gallery scene.
 * @default {"HelpWindow":"","HelpWindow_BgType:num":"0","HelpWindow_RectJS:func":"\"const wx = 0;\\nconst wy = this.helpAreaTop();\\nconst ww = Graphics.boxWidth;\\nconst wh = this.helpAreaHeight();\\nreturn new Rectangle(wx, wy, ww, wh);\"","CategoryWindow":"","CategoryWindow_BgType:num":"0","CategoryWindowCommands":"","CategoryWindow_AddAllCommand:eval":"true","AllCommandIcon:num":"307","CategoryWindow_ShowUnlistedCommand:eval":"true","UnlistedCommandIcon:num":"308","CategoryWindow_Style:str":"auto","CategoryWindow_TextAlign:str":"center","CategoryWindow_RectJS:func":"\"const ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(1, false);\\nconst wx = 0;\\nconst wy = this.mainAreaTop();\\nreturn new Rectangle(wx, wy, ww, wh);\"","GalleryWindow":"","GalleryWindow_BgType:num":"0","LockedImgFilename:str":"","GalleryWindow_ImageBuffer:num":"4","GalleryWindow_ListingBack:eval":"true","GalleryWindow_MaxCols:num":"4","GalleryWindow_SpacingCols:num":"4","GalleryWindow_MaxRows:num":"3","GalleryWindow_SpacingRows:num":"4","GalleryWindow_Stagger:num":"160","GalleryWindow_StaggerToLeft:eval":"true","GalleryWindow_Text":"","GalleryWindow_Text_Variations":"","GalleryWindow_Text_VariationsShow:eval":"true","GalleryWindow_Text_VariationsShowSingles:eval":"false","GalleryWindow_Text_VariationsAlignX:str":"right","GalleryWindow_Text_VariationsAlignY:str":"bottom","GalleryWindow_Text_Completion":"","GalleryWindow_Text_CompletionShow:eval":"true","GalleryWindow_Text_CompletionDecimals:num":"2","GalleryWindow_Text_CompletionFontFace:str":"Arial","GalleryWindow_Text_CompletionFontSize1:num":"26","GalleryWindow_Text_CompletionFontSize2:num":"36","GalleryWindow_Text_CompletionOffset":"","GalleryWindow_Text_CompletionAngle:num":"20","GalleryWindow_Text_CompletionOffsetX:num":"+0","GalleryWindow_Text_CompletionOffsetY:num":"+0","GalleryWindow_Text_Progress":"","GalleryWindow_Text_ProgressShow:eval":"true","GalleryWindow_Text_ProgressDecimals:num":"2","GalleryWindow_Text_ProgressFontFace:str":"Arial","GalleryWindow_Text_ProgressFontSize1:num":"26","GalleryWindow_Text_ProgressFontSize2:num":"48","GalleryWindow_Text_ProgressOffset":"","GalleryWindow_Text_ProgressAngle:num":"-20","GalleryWindow_Text_ProgressOffsetX:num":"+0","GalleryWindow_Text_ProgressOffsetY:num":"+0","GalleryWindow_RectJS:func":"\"const ww = Graphics.boxWidth;\\nconst wh = this.mainAreaHeight() - this.calcWindowHeight(1, false);\\nconst wx = 0;\\nconst wy = this.mainAreaTop() + this.calcWindowHeight(1, false);\\nreturn new Rectangle(wx, wy, ww, wh);\""}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Category List Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Category:
 *
 * @param Key:str
 * @text ID Key
 * @desc This category's identification key. Categories require
 * unique keys for the plugin to differentiate them.
 * @default (Needs Key)
 *
 * @param Text:str
 * @text Text
 * @desc This category's command text.
 * @default Untitled
 *
 * @param Icon:num
 * @text Icon
 * @desc Icon used for this category.
 * Use 0 for no icon.
 * @default 0
 *
 * @param Description:json
 * @text Help Description
 * @type note
 * @desc A description of the CG Gallery listing.
 * Text codes allowed.
 * @default "Line1\nLine2"
 * 
 */
/* ----------------------------------------------------------------------------
 * Listing Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Listing:
 *
 * @param Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @require 1
 * @desc Filename used for the CG Gallery listing.
 * This will be used as the CG Gallery thumbnail, too.
 * @default Untitled
 *
 * @param Variations:arraystr
 * @text Variations
 * @parent Filename:str
 * @type file[]
 * @dir img/pictures/
 * @require 1
 * @desc Variations of the CG Gallery listing.
 * @default []
 *
 * @param Category:str
 * @text Category
 * @desc The category this image is listed under.
 * If unlisted, the image will be listed under "Unlisted".
 * @default Unlisted
 *
 * @param Description:json
 * @text Help Description
 * @type note
 * @desc A description of the CG Gallery listing.
 * Text codes allowed.
 * @default "Line1\nLine2"
 *
 */
/* ----------------------------------------------------------------------------
 * System Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~System:
 *
 * @param AutoUnlocks
 * @text Auto-Unlocks
 *
 * @param AutoUnlockShowPicture:eval
 * @text Show Picture?
 * @parent AutoUnlocks
 * @type boolean
 * @on Auto-Unlock
 * @off Ignore
 * @desc Auto-unlock listings for the CG Gallery when using
 * "Show Picture" event commands?
 * @default true
 *
 * @param AutoUnlockVariations:eval
 * @text Variations?
 * @parent AutoUnlocks
 * @type boolean
 * @on Auto-Unlock
 * @off Ignore
 * @desc Auto-unlock variations for listings for the CG Gallery?
 * @default false
 * 
 * @param Scene_CG_Gallery
 *
 * @param MoveDistance:num
 * @text Move Distance
 * @parent Scene_CG_Gallery
 * @desc How many pixels should pictures move per frame?
 * @default 4
 *
 */
/* ----------------------------------------------------------------------------
 * MainMenu Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MainMenu:
 *
 * @param Name:str
 * @text Command Name
 * @parent Options
 * @desc Name of the 'CG Gallery' option in the Main Menu.
 * @default CG Gallery
 *
 * @param ShowMainMenu:eval
 * @text Show in Main Menu?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add the 'CG Gallery' option to the Main Menu by default?
 * @default true
 *
 * @param EnableMainMenu:eval
 * @text Enable in Main Menu?
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable the 'CG Gallery' option to the Main Menu by default?
 * @default true
 *
 * @param ShowTitleCommand:eval
 * @text Show in Title Command?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add the "CG Gallery" the Title Command Window?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Background Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BgSettings:
 *
 * @param SnapshotOpacity:num
 * @text Snapshop Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc Snapshot opacity for the scene.
 * @default 192
 *
 * @param BgFilename1:str
 * @text Background 1
 * @type file
 * @dir img/titles1/
 * @require 1
 * @desc Filename used for the bottom background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 * @param BgFilename2:str
 * @text Background 2
 * @type file
 * @dir img/titles2/
 * @require 1
 * @desc Filename used for the upper background image.
 * Leave empty if you don't wish to use one.
 * @default 
 *
 */
/* ----------------------------------------------------------------------------
 * Sound Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Sound:
 *
 * @param View
 * @text Select Image
 * 
 * @param viewName:str
 * @text Filename
 * @parent View
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Book1
 *
 * @param viewVolume:num
 * @text Volume
 * @parent View
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param viewPitch:num
 * @text Pitch
 * @parent View
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param viewPan:num
 * @text Pan
 * @parent View
 * @desc Pan of the sound effect played.
 * @default 0
 *
 * @param Change
 * @text Change Variation
 * 
 * @param changeName:str
 * @text Filename
 * @parent Change
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc Filename of the sound effect played.
 * @default Book2
 *
 * @param changeVolume:num
 * @text Volume
 * @parent Change
 * @type number
 * @max 100
 * @desc Volume of the sound effect played.
 * @default 90
 *
 * @param changePitch:num
 * @text Pitch
 * @parent Change
 * @type number
 * @desc Pitch of the sound effect played.
 * @default 100
 *
 * @param changePan:num
 * @text Pan
 * @parent Change
 * @desc Pan of the sound effect played.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Vocabulary Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param CategoryWindowCommands
 * @text Special Categories
 *
 * @param AllCommandText:str
 * @text "All" Command
 * @parent CategoryWindowCommands
 * @desc Text used for the "All" Category.
 * @default All
 *
 * @param UnlistedCommandText:str
 * @text "Unlisted" Command
 * @parent CategoryWindowCommands
 * @desc Text used for the "Unlisted" Category.
 * @default Unlisted
 *
 * @param HelpDesc
 * @text Help Descriptions
 *
 * @param AllCommandDescription:json
 * @text "All" Category
 * @parent HelpDesc
 * @type note
 * @desc A description used for the "All" Category.
 * Text codes allowed.
 * @default "View all types of images for this gallery."
 *
 * @param UnlistedCommandDescription:json
 * @text "Unlisted" Category
 * @parent HelpDesc
 * @type note
 * @desc A description used for the "Unlisted" Category.
 * Text codes allowed.
 * @default "These images do not have a category."
 *
 * @param LockedHelpDescription:json
 * @text Not Unlocked Image
 * @parent HelpDesc
 * @type note
 * @desc A description used for yet to be unlocked images.
 * Text codes allowed.
 * @default "You have not unlocked this image yet."
 * 
 * @param GalleryWindow
 * @text Gallery Window
 * 
 * @param GalleryWindowVariations
 * @text Variations
 * @parent GalleryWindow
 *
 * @param GalleryWindow_Text_VariationComplete:str
 * @text Complete Text
 * @parent GalleryWindowVariations
 * @desc Text displayed for listings with complete unlocks.
 * Leave empty to not use.
 * @default \}★
 *
 * @param GalleryWindow_Text_VariationFmt:str
 * @text Text Format
 * @parent GalleryWindowVariations
 * @desc Text format for listings with variations left.
 * %1 - Percent, %2 - Unlocked, %3 - Total
 * @default \}%2/%3
 * 
 * @param GalleryWindowCompletion
 * @text Completion
 * @parent GalleryWindow
 *
 * @param GalleryWindow_Text_CompletionVocab:str
 * @text Vocabulary
 * @parent GalleryWindowCompletion
 * @desc Main vocabulary used for this text.
 * @default Completion
 *
 * @param GalleryWindow_Text_CompletionFmt:str
 * @text Percentage Format
 * @parent GalleryWindowCompletion
 * @desc Text format used for completion percentage.
 * %1 - Percent, %2 - Unlocked, %3 - Total
 * @default %1%
 * 
 * @param GalleryWindowProgress
 * @text Progress
 * @parent GalleryWindow
 *
 * @param GalleryWindow_Text_ProgressVocab:str
 * @text Vocabulary
 * @parent GalleryWindowProgress
 * @desc Main vocabulary used for this text.
 * @default Progress
 *
 * @param GalleryWindow_Text_ProgressFmt:str
 * @text Progress Format
 * @parent GalleryWindowProgress
 * @desc Text format used for progress unlocked.
 * %1 - Percent, %2 - Unlocked, %3 - Total
 * @default %2/%3
 *
 * @param ButtonAssist
 * @text Button Assist Window
 *
 * @param ButtonAssistVocab_Border:str
 * @text Border
 * @parent ButtonAssist
 * @desc Text used for toggling border and borderless.
 * Requires VisuMZ_0_CoreEngine!
 * @default Border
 *
 * @param ButtonAssistVocab_Gallery:str
 * @text Gallery
 * @parent ButtonAssist
 * @desc Text used for returning back to the gallery.
 * Requires VisuMZ_0_CoreEngine!
 * @default Gallery
 *
 * @param ButtonAssistVocab_Next:str
 * @text Next Variation
 * @parent ButtonAssist
 * @desc Text used for going to next variation.
 * Requires VisuMZ_0_CoreEngine!
 * @default Next
 *
 * @param ButtonAssistVocab_Prev:str
 * @text Previous Variation
 * @parent ButtonAssist
 * @desc Text used for going to previous variation.
 * Requires VisuMZ_0_CoreEngine!
 * @default Prev
 *
 * @param ButtonAssistVocab_Reset:str
 * @text Reset Zoom/Position
 * @parent ButtonAssist
 * @desc Text used for resetting the zoom and position.
 * Requires VisuMZ_0_CoreEngine!
 * @default Reset
 *
 * @param ButtonAssistVocab_Zoom:str
 * @text Zoom Change
 * @parent ButtonAssist
 * @desc Text used for changing the zoom scale.
 * Requires VisuMZ_0_CoreEngine!
 * @default Zoom
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param HelpWindow
 * @text Window_Help
 *
 * @param HelpWindow_BgType:num
 * @text Background Type
 * @parent HelpWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param HelpWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent HelpWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = 0;\nconst wy = this.helpAreaTop();\nconst ww = Graphics.boxWidth;\nconst wh = this.helpAreaHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param CategoryWindow
 * @text Window_CG_Category
 *
 * @param CategoryWindow_BgType:num
 * @text Background Type
 * @parent CategoryWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 * 
 * @param CategoryWindowCommands
 * @text Special Categories
 * @parent CategoryWindow
 *
 * @param CategoryWindow_AddAllCommand:eval
 * @text Add All Command?
 * @parent CategoryWindowCommands
 * @type boolean
 * @on Add
 * @off Ignore
 * @desc Add the "All" command for the CG Gallery Category window.
 * @default true
 *
 * @param AllCommandIcon:num
 * @text "All" Icon
 * @parent CategoryWindow_AddAllCommand:eval
 * @desc Icon used for the "All" Category.
 * @default 307
 *
 * @param CategoryWindow_ShowUnlistedCommand:eval
 * @text Show Unlisted?
 * @parent CategoryWindowCommands
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the "Unlisted" command for the CG Gallery Category window if applicable.
 * @default true
 *
 * @param UnlistedCommandIcon:num
 * @text "Unlisted" Icon
 * @parent CategoryWindow_ShowUnlistedCommand:eval
 * @desc Icon used for the "Unlisted" Category.
 * @default 308
 *
 * @param CategoryWindow_Style:str
 * @text Style
 * @parent CategoryWindow
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands for this window?
 * @default auto
 *
 * @param CategoryWindow_TextAlign:str
 * @text Text Align
 * @parent CategoryWindow
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for this window?
 * @default center
 *
 * @param CategoryWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent CategoryWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(1, false);\nconst wx = 0;\nconst wy = this.mainAreaTop();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param GalleryWindow
 * @text Window_CG_Gallery
 *
 * @param GalleryWindow_BgType:num
 * @text Background Type
 * @parent GalleryWindow
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param LockedImgFilename:str
 * @text Custom Locked Image
 * @parent GalleryWindow
 * @type file
 * @dir img/pictures/
 * @require 1
 * @desc Custom picture graphic used for entries that have yet to be unlocked.
 * @default 
 *
 * @param GalleryWindow_ImageBuffer:num
 * @text Image Buffer
 * @parent GalleryWindow
 * @type number
 * @desc How many pixels of buffer range should there be for selected images?
 * @default 4
 *
 * @param GalleryWindow_ListingBack:eval
 * @text Listing Background?
 * @parent GalleryWindow
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the dark background for listings?
 * @default true
 *
 * @param GalleryWindow_MaxCols:num
 * @text Max Columns
 * @parent GalleryWindow
 * @type number
 * @min 1
 * @desc Max columns used for this window.
 * @default 4
 *
 * @param GalleryWindow_SpacingCols:num
 * @text Spacing
 * @parent GalleryWindow_MaxCols:num
 * @type number
 * @min 0
 * @desc Column spacing for this window.
 * @default 4
 *
 * @param GalleryWindow_MaxRows:num
 * @text Max Rows
 * @parent GalleryWindow
 * @type number
 * @min 1
 * @desc Max rows used for this window.
 * @default 3
 *
 * @param GalleryWindow_SpacingRows:num
 * @text Spacing
 * @parent GalleryWindow_MaxRows:num
 * @type number
 * @min 0
 * @desc Row spacing for this window.
 * @default 4
 *
 * @param GalleryWindow_Stagger:num
 * @text Stagger
 * @parent GalleryWindow
 * @type number
 * @desc How many pixels should the gallery entries stagger by?
 * This is the diagonal listing effect.
 * @default 160
 *
 * @param GalleryWindow_StaggerToLeft:eval
 * @text Towards Left?
 * @parent GalleryWindow_Stagger:num
 * @type boolean
 * @on Towards Left
 * @off Towards Right
 * @desc Which direction should the stagger be going towards?
 * @default true
 * 
 * @param GalleryWindow_Text
 * @text Text
 * @parent GalleryWindow
 * 
 * @param GalleryWindow_Text_Variations
 * @text Variations
 * @parent GalleryWindow_Text
 *
 * @param GalleryWindow_Text_VariationsShow:eval
 * @text Show?
 * @parent GalleryWindow_Text_Variations
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show variations on the gallery thumbnail?
 * @default true
 *
 * @param GalleryWindow_Text_VariationsShowSingles:eval
 * @text Display Singles?
 * @parent GalleryWindow_Text_Variations
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show text on listings with no variations?
 * @default false
 *
 * @param GalleryWindow_Text_VariationsAlignX:str
 * @text Horz Text Align
 * @parent GalleryWindow_Text_Variations
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Horizontal alignment for this text?
 * @default right
 *
 * @param GalleryWindow_Text_VariationsAlignY:str
 * @text Vert Text Align
 * @parent GalleryWindow_Text_Variations
 * @type combo
 * @option top
 * @option middle
 * @option bottom
 * @desc Vertical alignment for this text?
 * @default bottom
 * 
 * @param GalleryWindow_Text_Completion
 * @text Completion
 * @parent GalleryWindow_Text
 *
 * @param GalleryWindow_Text_CompletionShow:eval
 * @text Show?
 * @parent GalleryWindow_Text_Completion
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show this text?
 * @default true
 *
 * @param GalleryWindow_Text_CompletionDecimals:num
 * @text Decimal Places
 * @parent GalleryWindow_Text_Completion
 * @type number
 * @desc How many decimal places should the percentage value go to?
 * @default 2
 *
 * @param GalleryWindow_Text_CompletionFontFace:str
 * @text Font Name
 * @parent GalleryWindow_Text_Completion
 * @desc What is the font family name (NOT filename) of the font?
 * Look up the name via Windows Font Preview.
 * @default Arial
 *
 * @param GalleryWindow_Text_CompletionFontSize1:num
 * @text Font Size: Vocab
 * @parent GalleryWindow_Text_CompletionFontFace:str
 * @type number
 * @desc What is the font size of the main vocabulary?
 * @default 26
 *
 * @param GalleryWindow_Text_CompletionFontSize2:num
 * @text Font Size: Value
 * @parent GalleryWindow_Text_CompletionFontFace:str
 * @type number
 * @desc What is the font size of the value?
 * @default 36
 *
 * @param GalleryWindow_Text_CompletionOffset
 * @text Offset
 * @parent GalleryWindow_Text_Completion
 *
 * @param GalleryWindow_Text_CompletionAngle:num
 * @text Angle
 * @parent GalleryWindow_Text_CompletionOffset
 * @desc What angle should this text be shown at?
 * @default 20
 *
 * @param GalleryWindow_Text_CompletionOffsetX:num
 * @text Offset X
 * @parent GalleryWindow_Text_CompletionOffset
 * @desc How many pixels to offset the x position?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param GalleryWindow_Text_CompletionOffsetY:num
 * @text Offset Y
 * @parent GalleryWindow_Text_CompletionOffset
 * @desc How many pixels to offset the y position?
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param GalleryWindow_Text_Progress
 * @text Progress
 * @parent GalleryWindow_Text
 *
 * @param GalleryWindow_Text_ProgressShow:eval
 * @text Show?
 * @parent GalleryWindow_Text_Progress
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show this text?
 * @default true
 *
 * @param GalleryWindow_Text_ProgressDecimals:num
 * @text Decimal Places
 * @parent GalleryWindow_Text_Progress
 * @type number
 * @desc How many decimal places should the percentage value go to?
 * @default 2
 *
 * @param GalleryWindow_Text_ProgressFontFace:str
 * @text Font Name
 * @parent GalleryWindow_Text_Progress
 * @desc What is the font family name (NOT filename) of the font?
 * Look up the name via Windows Font Preview.
 * @default Arial
 *
 * @param GalleryWindow_Text_ProgressFontSize1:num
 * @text Font Size: Vocab
 * @parent GalleryWindow_Text_ProgressFontFace:str
 * @type number
 * @desc What is the font size of the main vocabulary?
 * @default 26
 *
 * @param GalleryWindow_Text_ProgressFontSize2:num
 * @text Font Size: Value
 * @parent GalleryWindow_Text_ProgressFontFace:str
 * @type number
 * @desc What is the font size of the value?
 * @default 48
 *
 * @param GalleryWindow_Text_ProgressOffset
 * @text Offset
 * @parent GalleryWindow_Text_Progress
 *
 * @param GalleryWindow_Text_ProgressAngle:num
 * @text Angle
 * @parent GalleryWindow_Text_ProgressOffset
 * @desc What angle should this text be shown at?
 * @default -20
 *
 * @param GalleryWindow_Text_ProgressOffsetX:num
 * @text Offset X
 * @parent GalleryWindow_Text_ProgressOffset
 * @desc How many pixels to offset the x position?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param GalleryWindow_Text_ProgressOffsetY:num
 * @text Offset Y
 * @parent GalleryWindow_Text_ProgressOffset
 * @desc How many pixels to offset the y position?
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param GalleryWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent GalleryWindow
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Graphics.boxWidth;\nconst wh = this.mainAreaHeight() - this.calcWindowHeight(1, false);\nconst wx = 0;\nconst wy = this.mainAreaTop() + this.calcWindowHeight(1, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
//=============================================================================

const _0x1ea0b5=_0xf3f1;function _0x1d5f(){const _0x259b8a=['hide','stringify','createCommandNameWindow','zoom','MdjaS','toFixed','Scene_Title_createCommandWindow','Untitled','DRAW_ITEM_BACKGROUND','CategoryWindow_ShowUnlistedCommand','meLnP','changePitch','parse','DefaultUnlocked','Scene_Menu_createCommandWindow','14261990MTAGIF','GalleryWindow_Text_VariationComplete','viewVolume','unlockImageForCgGallery','DjrWR','processViewModeTouchRelease','offset','addAllCommand','_context','_listingNames','show','CgGalleryTotalSize','variantComplete','addChild','prev','sort','drawItem','GalleryWindow_RectJS','isMainMenuCgGalleryVisible','CG_UnlockAllImagesPerma','close','addUnlistedCommand','Window','isCommandEnabled','update','HMkip','resetFontSettings','ARRAYSTR','ZZVUm','Game_System_initialize','dRIZi','format','TEXT_ALIGN','176496EqCMon','shift','pop','colSpacing','IsCgGalleryListing','_list','categoryWindowRect','pviAS','updateHelp','decimals','_variationIndex','NUM','Filename','setMainMenuCgGalleryEnabled','addCommandListCommands','SystemEnableCGGalleryMenu','Description','round','CG_GALLERY_ADD_COMMAND','createGalleryWindow','Sound','AutoUnlockVariations','bitmap','BgFilename2','_scene','pagedown','unlockAllVariations','UgzPv','IueeW','CategoryWindow_Style','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','_galleryWindow','UnlistedCommandIcon','LockedHelpDescription','name','itemRect','buttonAssistText5','Category','nmUjT','XyzNx','SnapshotOpacity','_helpWindow','createBackground','prepareViewMode','heFCg','callUpdateHelp','4728756fXUUmD','untitled','WjYCJ','setText','loadPicture','gray','viewPan','initCgGalleryMainMenu','processViewModeScale','startViewMode','exitViewMode','vJRNj','drawVariationCount','createPageButtons','CategoryWindow_AddAllCommand','fRBOe','buttonAssistText3','ConfigManager_makeData','24QnhQXy','COMMAND_LIST','setHandler','visible','createCompletionSprite','LockedImgFilename','textSizeEx','_completionSprite','processViewModeReset','scale','max','_cgGalleryFullUnlock','enabled','commandNameWindowCenter','createCustomBackgroundImages','parameters','ButtonAssistVocab_Zoom','System','MAXROW','right','isWheelScrollEnabled','EVAL','processViewModeBorderless','calcWindowHeight','middle','Vocab','GalleryWindow_Text_ProgressFontFace','CGGallery','toUpperCase','commandCgGallery','_wheelCooldown','topRow','_itemWidth','drawItemBackground','gallery','cgGalleryCompletionRate','ARRAYNUM','_pageupButton','yAlign','Show','BLLcQ','itemTextAlign','Name','VisuMZ_1_MainMenuCore','loadTitle2','GalleryWindow_Text_VariationsAlignY','COL_SPACING','commandStyleCheck','_backSprite1','SnfVA','Variations','_scrollTargetY','isPlaytest','registerCommand','createHelpWindow','min','playCursor','CategoryWindow_TextAlign','GalleryWindow_Text_ProgressFontSize1','toLowerCase','createBlackBackgroundImage','push','IXCEv','STAGGER_FULL','eAGtv','_blackBgSprite','68646icoLVB','CG_WINDOW_BGTYPE','commandCategory','setBackgroundType','_categoryWindow','_progressSprite','lockedImgFilename','cursorDown','Arial','deselect','GalleryWindow_Text_ProgressFmt','STRUCT','initMembers','STR','DRAW_VARIATION','WSNqd','playCancel','GalleryWindow_SpacingCols','viewPitch','black','fontBold','mainAreaHeight','_hasUnlistedCategories','tdUDv','GalleryWindow_Text_ProgressOffsetX','_category','isCgGalleryCommandVisible','auto','GalleryWindow_Text_ProgressFontSize2','blt','commandNameWindowDrawBackground','create','drawCircle','buttonAssistText1','boxWidth','buttonAssistText2','anchor','smoothScrollTo','isCgGalleryUnlocked','icon','_pagedownButton','clear','4834328tEmFlh','Shmto','_cancelButton','_commandWindow','playViewCgImage','oLzrH','iconWidth','GalleryWindow_Text_CompletionFontFace','cgGallery','IUOYB','fillRect','isRepeated','maxCols','tab','_variationList','Tdxcu','initialize','dBTfe','active','version','cancel','EnableMainMenu','padding','maxScrollY','nZcnd','ARRAYJSON','wasoM','createViewSprite','cgGalleryUnlocks','isPressed','percentFmt','aEgCt','createCommandWindow','_customModified','addOriginalCommands','ShowTitleCommand','popScene','floor','ConfigManager_applyData','ButtonAssistVocab_Gallery','SHOW_UNLISTED_COMMAND','cachedCgGalleryLockedImage','cgGalleryCurrentCount','findSymbol','GalleryWindow_Text_CompletionOffsetX','ULcWo','_totalSize','Icon','lockedImg','drawIcon','ceil','commandStyle','applyData','adjustSpriteDown','description','itemLineRect','fSYZH','ARRAYEVAL','save','BgSettings','CG_WINDOW_MOVE_DIST','isReleased','bind','commandName','updateSmoothScroll','haisJ','jyYrh','wcJup','GalleryWindow_MaxCols','NMQbu','MsXoq','map','reset','SystemShowCGGalleryMenu','drawTextEx','DefaultUnlocks','isMainMenuCgGalleryEnabled','_categories','GalleryWindow_Stagger','MAXCOL','cgGalleryTotalSize','getBackgroundOpacity','next','makeCommandList','autoUnlock','onCategoryCancel','AllCommandIcon','centerSprite','changeVolume','ext','needsPageButtons','playOkSound','status','fontSize2','\x5cI[%1]%2','HELP_WINDOW_BGTYPE','_itemHeight','_viewSprite','BgFilename1','ROW_SPACING','LooIQ','addLoadListener','_scrollTargetX','CATEGORY_WINDOW_BGTYPE','Game_Picture_show','listing','ARRAYFUNC','length','JmQvN','GalleryWindow_ImageBuffer','COMPLETION_SPRITE','addCgGalleryCommand','rgba(0,\x200,\x200,\x200)','changeName','hasCgUnlockedImage','prototype','bottom','Key','updateCompletionSpriteBitmap','GalleryWindow_Text_CompletionFontSize2','drawPicture','addCgGalleryCommandAutomatically','MNIRz','AllCommandText','15ciMNxT','cgGalleryMenuCommand','onCHx','Settings','STAGGER_LEFT','updateGalleryWindow','opacity','reselect','FUNC','bmRKZ','text','iconHeight','fontSize1','cgGalleryHasUnlockedImage','processViewModeMouseMove','HelpWindow_BgType','COMMAND_STYLE','call','unlisted','refreshCursor','GalleryWindow_MaxRows','MainMenu','XBuFS','itemHeight','getInputMultiButtonStrings','exit','MRfKX','_viewModeVisible','IMG_BUFFER','clamp','index','all','GalleryWindow_Text_VariationFmt','ButtonAssistVocab_Border','updateCommandNameWindow','height','category','GalleryWindow_Text_CompletionVocab','fontFace','icons','processViewModeMove','Listing','_backSprite2','531DimIvM','angle','constructor','playEquip','playSe','1618246KmcoLi','updatePageButtons','setCategory','itemWidth','ConvertParams','KLsOA','Text','setTopRow','refresh','currentExt','imageSmoothingEnabled','setClickHandler','fontSize','processVariationChange','buttonAssist','GalleryWindow_Text_VariationsShowSingles','_cgGallery_MainMenu','setHelpWindow','undefined','includes','createProgressSprite','itemRectWithPadding','helpAreaTop','shown','_cached_CGGallery_Image','textFmt','iconText','isSceneBattle','buttonAssistKey1','Enable','isCgGalleryCommandEnabled','BjGgx','AutoUnlockShowPicture','_viewMode','Ihhzz','setMainMenuCgGalleryVisible','trim','CG_UnlockImages','GalleryWindow_Text_CompletionFmt','playNextCgVariation','irQYI','CG_UnlockAllImagesDebug','drawText','helpWindowRect','Categories','PROGRESS_SPRITE','TYyLA','HelpWindow_RectJS','maxScrollX','center','szySD','dir8','adjustSprite','addWindow','splice','setGalleryWindow','innerHeight','innerWidth','deactivate','QhJfs','_commandNameWindow','width','GalleryWindow_Text_ProgressShow','_defaultUnlocks','zfqsD','GalleryWindow_Text_ProgressAngle','onTouchSelect','windowPadding','_buttonAssistWindow','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','CgGalleryCategories','drawItemStyleIconText','ZMUeO','lineHeight','ADD_ALL_COMMAND','createCategoryWindow','UaRcr','updateViewMode','CG_GALLERY','PIVJQ','aZQrO','Window_MenuCommand_addOriginalCommands','mainAreaTop','listingMatchesCategory','JSON','pageup','651222msgFsB','select','Window_TitleCommand_makeCommandList','IOkvw','addCommand','contents','KbrjJ','GalleryWindow_Text_CompletionDecimals','MmXgW','match','galleryWindowRect','arePageButtonsEnabled','paintOpacity','CategoryWindow_BgType','wheelY','updateProgressSpriteBitmap','processWheelScroll','AQAxi','border','changePaintOpacity','scaleSpriteDown','ButtonAssistVocab_Reset','drawItemStyleIcon','HasUnlistedCategories','helpDesc','viewName','processViewModeCancel','activate','setBackgroundOpacity'];_0x1d5f=function(){return _0x259b8a;};return _0x1d5f();}(function(_0x26c212,_0x54d3d2){const _0xf875bb=_0xf3f1,_0x4a4e16=_0x26c212();while(!![]){try{const _0x3453c4=parseInt(_0xf875bb(0x2cc))/0x1*(parseInt(_0xf875bb(0x28a))/0x2)+parseInt(_0xf875bb(0x278))/0x3+parseInt(_0xf875bb(0x2f6))/0x4+parseInt(_0xf875bb(0x372))/0x5*(parseInt(_0xf875bb(0x1fd))/0x6)+-parseInt(_0xf875bb(0x3a2))/0x7+parseInt(_0xf875bb(0x24a))/0x8*(-parseInt(_0xf875bb(0x39d))/0x9)+-parseInt(_0xf875bb(0x229))/0xa;if(_0x3453c4===_0x54d3d2)break;else _0x4a4e16['push'](_0x4a4e16['shift']());}catch(_0x215d44){_0x4a4e16['push'](_0x4a4e16['shift']());}}}(_0x1d5f,0xee13a));var label=_0x1ea0b5(0x2a5),tier=tier||0x0,dependencies=[],pluginData=$plugins['filter'](function(_0x369060){const _0x444132=_0x1ea0b5;return _0x369060[_0x444132(0x352)]&&_0x369060[_0x444132(0x32c)][_0x444132(0x1ba)]('['+label+']');})[0x0];VisuMZ[label][_0x1ea0b5(0x375)]=VisuMZ[label][_0x1ea0b5(0x375)]||{},VisuMZ['ConvertParams']=function(_0x31f353,_0x4965ed){const _0x4d3afc=_0x1ea0b5;for(const _0xaa730 in _0x4965ed){if(_0xaa730['match'](/(.*):(.*)/i)){const _0x11b220=String(RegExp['$1']),_0x308f6e=String(RegExp['$2'])[_0x4d3afc(0x2a6)]()[_0x4d3afc(0x1cb)]();let _0x2517f2,_0x332979,_0x218863;switch(_0x308f6e){case _0x4d3afc(0x255):_0x2517f2=_0x4965ed[_0xaa730]!==''?Number(_0x4965ed[_0xaa730]):0x0;break;case _0x4d3afc(0x2ae):_0x332979=_0x4965ed[_0xaa730]!==''?JSON['parse'](_0x4965ed[_0xaa730]):[],_0x2517f2=_0x332979['map'](_0x346582=>Number(_0x346582));break;case _0x4d3afc(0x29f):_0x2517f2=_0x4965ed[_0xaa730]!==''?eval(_0x4965ed[_0xaa730]):null;break;case _0x4d3afc(0x32f):_0x332979=_0x4965ed[_0xaa730]!==''?JSON[_0x4d3afc(0x226)](_0x4965ed[_0xaa730]):[],_0x2517f2=_0x332979[_0x4d3afc(0x33d)](_0xaada41=>eval(_0xaada41));break;case _0x4d3afc(0x1fb):_0x2517f2=_0x4965ed[_0xaa730]!==''?JSON['parse'](_0x4965ed[_0xaa730]):'';break;case _0x4d3afc(0x30f):_0x332979=_0x4965ed[_0xaa730]!==''?JSON['parse'](_0x4965ed[_0xaa730]):[],_0x2517f2=_0x332979['map'](_0x4a62e0=>JSON[_0x4d3afc(0x226)](_0x4a62e0));break;case _0x4d3afc(0x37a):_0x2517f2=_0x4965ed[_0xaa730]!==''?new Function(JSON['parse'](_0x4965ed[_0xaa730])):new Function('return\x200');break;case _0x4d3afc(0x360):_0x332979=_0x4965ed[_0xaa730]!==''?JSON[_0x4d3afc(0x226)](_0x4965ed[_0xaa730]):[],_0x2517f2=_0x332979['map'](_0xaace8e=>new Function(JSON['parse'](_0xaace8e)));break;case _0x4d3afc(0x2d9):_0x2517f2=_0x4965ed[_0xaa730]!==''?String(_0x4965ed[_0xaa730]):'';break;case _0x4d3afc(0x244):_0x332979=_0x4965ed[_0xaa730]!==''?JSON['parse'](_0x4965ed[_0xaa730]):[],_0x2517f2=_0x332979[_0x4d3afc(0x33d)](_0xbc8381=>String(_0xbc8381));break;case _0x4d3afc(0x2d7):_0x218863=_0x4965ed[_0xaa730]!==''?JSON[_0x4d3afc(0x226)](_0x4965ed[_0xaa730]):{},_0x2517f2=VisuMZ[_0x4d3afc(0x3a6)]({},_0x218863);break;case'ARRAYSTRUCT':_0x332979=_0x4965ed[_0xaa730]!==''?JSON[_0x4d3afc(0x226)](_0x4965ed[_0xaa730]):[],_0x2517f2=_0x332979[_0x4d3afc(0x33d)](_0x5c1c48=>VisuMZ['ConvertParams']({},JSON[_0x4d3afc(0x226)](_0x5c1c48)));break;default:continue;}_0x31f353[_0x11b220]=_0x2517f2;}}return _0x31f353;},(_0x21fcdf=>{const _0x14df76=_0x1ea0b5,_0x232b69=_0x21fcdf[_0x14df76(0x26c)];for(const _0x1bd157 of dependencies){if(!Imported[_0x1bd157]){if(_0x14df76(0x247)!==_0x14df76(0x247)){if(this[_0x14df76(0x2a8)]){this[_0x14df76(0x2a8)]--;return;}_0xf04bb1[_0x14df76(0x369)][_0x14df76(0x1e9)][_0x14df76(0x383)](this,_0x41d435);}else{alert(_0x14df76(0x1ec)[_0x14df76(0x248)](_0x232b69,_0x1bd157)),SceneManager['exit']();break;}}}const _0x4467b2=_0x21fcdf['description'];if(_0x4467b2[_0x14df76(0x206)](/\[Version[ ](.*?)\]/i)){const _0x27df9f=Number(RegExp['$1']);if(_0x27df9f!==VisuMZ[label][_0x14df76(0x309)]){if(_0x14df76(0x203)===_0x14df76(0x203))alert('%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.'['format'](_0x232b69,_0x27df9f)),SceneManager[_0x14df76(0x38b)]();else{const _0x30e903=new _0x104991();_0x30e903['bitmap']=new _0x12c6cb(0x64,0x64),_0x30e903[_0x14df76(0x378)]=0x0,this[_0x14df76(0x357)]=_0x30e903,this[_0x14df76(0x236)](_0x30e903),this[_0x14df76(0x32b)](_0x30e903);}}}if(_0x4467b2[_0x14df76(0x206)](/\[Tier[ ](\d+)\]/i)){const _0x369b79=Number(RegExp['$1']);if(_0x369b79<tier){if(_0x14df76(0x2c8)!==_0x14df76(0x224))alert(_0x14df76(0x268)[_0x14df76(0x248)](_0x232b69,_0x369b79,tier)),SceneManager['exit']();else{const _0x4eddf3=_0x31d311['CGGallery'][_0x14df76(0x1ed)]();return!_0x4eddf3[_0x14df76(0x1ba)](_0x53f9a0);}}else'irQYI'!==_0x14df76(0x1cf)?(this['cursorDown'](![]),this[_0x14df76(0x2a8)]=0x8):tier=Math[_0x14df76(0x294)](_0x369b79,tier);}VisuMZ[_0x14df76(0x3a6)](VisuMZ[label]['Settings'],_0x21fcdf[_0x14df76(0x299)]);})(pluginData),PluginManager[_0x1ea0b5(0x2bf)](pluginData[_0x1ea0b5(0x26c)],_0x1ea0b5(0x1cc),_0x44794b=>{const _0x2fe59a=_0x1ea0b5;VisuMZ[_0x2fe59a(0x3a6)](_0x44794b,_0x44794b);const _0x426321=_0x44794b[_0x2fe59a(0x256)][_0x2fe59a(0x33d)](_0x3ff775=>_0x3ff775[_0x2fe59a(0x1cb)]());for(const _0x571b42 of _0x426321){$gameSystem['unlockImageForCgGallery'](_0x571b42);}}),PluginManager[_0x1ea0b5(0x2bf)](pluginData[_0x1ea0b5(0x26c)],_0x1ea0b5(0x1d0),_0x3e4813=>{const _0x195153=_0x1ea0b5;VisuMZ[_0x195153(0x3a6)](_0x3e4813,_0x3e4813),$gameTemp[_0x195153(0x295)]=!![];}),PluginManager[_0x1ea0b5(0x2bf)](pluginData[_0x1ea0b5(0x26c)],_0x1ea0b5(0x23c),_0x172ebc=>{const _0x52a712=_0x1ea0b5;VisuMZ['ConvertParams'](_0x172ebc,_0x172ebc);const _0x1e2711=VisuMZ[_0x52a712(0x2a5)][_0x52a712(0x375)][_0x52a712(0x39b)];for(const _0x45360c of _0x1e2711){if('QsrBq'==='QsrBq'){if(!_0x45360c)continue;if(_0x45360c['Filename']['toLowerCase']()[_0x52a712(0x1cb)]()===_0x52a712(0x279))continue;if(_0x45360c[_0x52a712(0x256)]['trim']()==='')continue;$gameSystem[_0x52a712(0x22c)](_0x45360c[_0x52a712(0x256)]);for(const _0x44dfff of _0x45360c[_0x52a712(0x2bc)]){if('pRejn'!==_0x52a712(0x21e)){if(_0x44dfff[_0x52a712(0x2c5)]()[_0x52a712(0x1cb)]()===_0x52a712(0x279))continue;if(_0x44dfff[_0x52a712(0x1cb)]()==='')continue;$gameSystem[_0x52a712(0x22c)](_0x44dfff);}else _0x7bb19[_0x52a712(0x2a5)][_0x52a712(0x246)]['call'](this),this[_0x52a712(0x27f)]();}}else(_0x19110f['y']<_0x53003b||_0x34c87e['y']>_0x51f785[_0x52a712(0x395)]-_0xdf81f4)&&this[_0x52a712(0x2a0)]();}}),PluginManager[_0x1ea0b5(0x2bf)](pluginData['name'],'CG_ResetAllImagesPerma',_0x5aec53=>{const _0x5d997b=_0x1ea0b5;VisuMZ[_0x5d997b(0x3a6)](_0x5aec53,_0x5aec53),$gameTemp['_cgGalleryFullUnlock']=![],ConfigManager['cgGalleryUnlocks']=[],ConfigManager['save']();}),PluginManager[_0x1ea0b5(0x2bf)](pluginData['name'],'SceneOpenCgGallery',_0x48a091=>{const _0x2b02a8=_0x1ea0b5;if(SceneManager[_0x2b02a8(0x1c2)]())return;SceneManager[_0x2b02a8(0x2c7)](Scene_CG_Gallery);}),PluginManager[_0x1ea0b5(0x2bf)](pluginData[_0x1ea0b5(0x26c)],_0x1ea0b5(0x259),_0x44764e=>{const _0x2a4141=_0x1ea0b5;VisuMZ['ConvertParams'](_0x44764e,_0x44764e),$gameSystem[_0x2a4141(0x257)](_0x44764e[_0x2a4141(0x1c4)]);}),PluginManager[_0x1ea0b5(0x2bf)](pluginData[_0x1ea0b5(0x26c)],_0x1ea0b5(0x33f),_0x2dcb6c=>{const _0x1d5d6d=_0x1ea0b5;VisuMZ[_0x1d5d6d(0x3a6)](_0x2dcb6c,_0x2dcb6c),$gameSystem[_0x1d5d6d(0x1ca)](_0x2dcb6c[_0x1d5d6d(0x2b1)]);}),ConfigManager[_0x1ea0b5(0x312)]=[],VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x289)]=ConfigManager['makeData'],ConfigManager['makeData']=function(){const _0x1b5101=_0x1ea0b5,_0x15002d=VisuMZ[_0x1b5101(0x2a5)][_0x1b5101(0x289)]['call'](this);return _0x15002d[_0x1b5101(0x312)]=this['cgGalleryUnlocks'],_0x15002d;},VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x31c)]=ConfigManager['applyData'],ConfigManager[_0x1ea0b5(0x32a)]=function(_0x5eded6){const _0x4505bc=_0x1ea0b5;VisuMZ[_0x4505bc(0x2a5)][_0x4505bc(0x31c)]['call'](this,_0x5eded6);if(_0x4505bc(0x312)in _0x5eded6){if('LmwKE'!==_0x4505bc(0x362))this[_0x4505bc(0x312)]=_0x5eded6[_0x4505bc(0x312)];else{_0x59a8ac=_0x1e565a['toLowerCase']()[_0x4505bc(0x1cb)]();if(this[_0x4505bc(0x2e5)]===_0x33fcf5)return;this[_0x4505bc(0x2e5)]=_0x237c13,this['refresh'](),this[_0x4505bc(0x3a9)](0x0),this[_0x4505bc(0x2d5)](),this[_0x4505bc(0x36c)](),this[_0x4505bc(0x20c)]();}}else this['cgGalleryUnlocks']=[];},ConfigManager[_0x1ea0b5(0x37f)]=function(){const _0x486431=_0x1ea0b5;return this['cgGalleryUnlocks'][_0x486431(0x361)]>0x0;},VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x341)]=function(){const _0x5b819a=_0x1ea0b5;if(this[_0x5b819a(0x1e6)]!==undefined)return this[_0x5b819a(0x1e6)];this['_defaultUnlocks']=this['_defaultUnlocks']||[];const _0x280fb8=VisuMZ['CGGallery'][_0x5b819a(0x375)][_0x5b819a(0x39b)];for(const _0x3d8fff of _0x280fb8){if(!_0x3d8fff)continue;VisuMZ['CGGallery'][_0x5b819a(0x375)][_0x5b819a(0x227)]['includes'](_0x3d8fff[_0x5b819a(0x256)])&&(_0x5b819a(0x1c6)==='VRyQS'?_0x39b482['playCursor']():this[_0x5b819a(0x1e6)][_0x5b819a(0x2c7)](_0x3d8fff[_0x5b819a(0x256)]));}return this[_0x5b819a(0x1e6)];},VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x24e)]=function(_0x1bdb1e){const _0x57956d=_0x1ea0b5;if(this[_0x57956d(0x232)]===undefined){this['_listingNames']=[];const _0x53b734=VisuMZ[_0x57956d(0x2a5)]['Settings']['Listing'];for(const _0x235b85 of _0x53b734){if(!_0x235b85)continue;if(_0x235b85[_0x57956d(0x256)][_0x57956d(0x2c5)]()[_0x57956d(0x1cb)]()===_0x57956d(0x279))continue;if(_0x235b85[_0x57956d(0x256)]['trim']()==='')continue;this[_0x57956d(0x232)][_0x57956d(0x2c7)](_0x235b85[_0x57956d(0x256)]);for(const _0x2938e0 of _0x235b85[_0x57956d(0x2bc)]){if('FTvKH'===_0x57956d(0x374)){_0x218427['prototype'][_0x57956d(0x277)]['call'](this);if(this[_0x57956d(0x1e3)])this[_0x57956d(0x394)]();}else{if(_0x2938e0[_0x57956d(0x2c5)]()['trim']()===_0x57956d(0x279))continue;if(_0x2938e0['trim']()==='')continue;this[_0x57956d(0x232)]['push'](_0x2938e0);}}}}return this[_0x57956d(0x232)][_0x57956d(0x1ba)](_0x1bdb1e);},VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x234)]=function(_0x138556){const _0x3ba9ea=_0x1ea0b5;_0x138556=_0x138556||_0x3ba9ea(0x391),this[_0x3ba9ea(0x324)]=this['_totalSize']||{};if(this[_0x3ba9ea(0x324)][_0x138556]!==undefined)return this[_0x3ba9ea(0x324)][_0x138556];this['_totalSize'][_0x138556]=0x0;const _0x431300=VisuMZ[_0x3ba9ea(0x2a5)]['Settings'][_0x3ba9ea(0x39b)];for(const _0x5370fd of _0x431300){if('ygcFv'!==_0x3ba9ea(0x265)){if(!_0x5370fd)continue;if(_0x5370fd['Filename'][_0x3ba9ea(0x2c5)]()[_0x3ba9ea(0x1cb)]()===_0x3ba9ea(0x279))continue;if(_0x5370fd[_0x3ba9ea(0x256)][_0x3ba9ea(0x1cb)]()==='')continue;VisuMZ[_0x3ba9ea(0x2a5)][_0x3ba9ea(0x1fa)](_0x5370fd,_0x138556)&&(_0x3ba9ea(0x20e)!=='UVBVB'?this[_0x3ba9ea(0x324)][_0x138556]+=_0x5370fd['Variations'][_0x3ba9ea(0x361)]+0x1:_0x43272b['x']=this[_0x3ba9ea(0x30c)]+_0x27b8b9[_0x3ba9ea(0x31b)](_0x53926c['STAGGER_FULL']/0x2));}else this[_0x3ba9ea(0x304)]['push'](_0x428fec);}return this[_0x3ba9ea(0x324)][_0x138556];},VisuMZ['CGGallery'][_0x1ea0b5(0x1fa)]=function(_0x461e9c,_0x2e5974){const _0x23ca96=_0x1ea0b5;_0x2e5974=_0x2e5974||_0x23ca96(0x391);if(_0x2e5974===_0x23ca96(0x391))return!![];const _0x415379=_0x461e9c[_0x23ca96(0x26f)][_0x23ca96(0x2c5)]()[_0x23ca96(0x1cb)]();if(_0x2e5974===_0x23ca96(0x384)){if('PHcGu'!==_0x23ca96(0x2fb))return!this[_0x23ca96(0x1ed)]()[_0x23ca96(0x1ba)](_0x415379);else{if(!_0x43e90a['PROGRESS_SPRITE']['show'])return;const _0x4a0761=new _0x45162d();this[_0x23ca96(0x236)](_0x4a0761);const _0x5b70eb=_0x94894[_0x23ca96(0x294)](_0x441920[_0x23ca96(0x2c9)],0x64);_0x4a0761[_0x23ca96(0x260)]=new _0x541983(_0x5b70eb,this[_0x23ca96(0x389)]()),_0x4a0761[_0x23ca96(0x2f0)]['x']=0.5,_0x4a0761[_0x23ca96(0x2f0)]['y']=0.5,this[_0x23ca96(0x2d1)]=_0x4a0761,this[_0x23ca96(0x20c)](),_0x539ddf['STAGGER_LEFT']?_0x4a0761['x']=this[_0x23ca96(0x1e4)]-(this[_0x23ca96(0x30c)]+_0x35073e[_0x23ca96(0x31b)](_0x7b2628[_0x23ca96(0x2c9)]/0x2)):_0x4a0761['x']=this[_0x23ca96(0x30c)]+_0x2db0bf[_0x23ca96(0x31b)](_0x518129['STAGGER_FULL']/0x2),_0x4a0761['y']=this['height']-this[_0x23ca96(0x30c)]-_0x3f0670[_0x23ca96(0x31b)](this[_0x23ca96(0x389)]()/0x2),_0x4a0761['x']+=_0x57998a['PROGRESS_SPRITE'][_0x23ca96(0x22f)]['x'],_0x4a0761['y']+=_0x74c9e0[_0x23ca96(0x1d4)][_0x23ca96(0x22f)]['y'],_0x4a0761[_0x23ca96(0x39e)]=-_0x2f4ebf[_0x23ca96(0x1d4)][_0x23ca96(0x39e)];}}return _0x415379===_0x2e5974;},VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x1ed)]=function(){const _0x533f82=_0x1ea0b5;if(this[_0x533f82(0x343)]!==undefined)return this['_categories'];this['_categories']=[];for(const _0x2c7494 of VisuMZ[_0x533f82(0x2a5)][_0x533f82(0x375)][_0x533f82(0x1d3)]){if('dBTfe'!==_0x533f82(0x307))this[_0x533f82(0x1eb)][_0x533f82(0x28d)]=this['_viewModeVisible'];else{const _0x9bc7f=_0x2c7494[_0x533f82(0x36b)]['toLowerCase']()[_0x533f82(0x1cb)]();this['_categories'][_0x533f82(0x2c7)](_0x9bc7f);}}return this['_categories'];},VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x214)]=function(){const _0x3b4e6e=_0x1ea0b5;if(this[_0x3b4e6e(0x2e2)]!==undefined)return this['_hasUnlistedCategories'];this['_hasUnlistedCategories']=![];const _0x54ce0b=VisuMZ[_0x3b4e6e(0x2a5)][_0x3b4e6e(0x1ed)](),_0x53985b=VisuMZ['CGGallery'][_0x3b4e6e(0x375)][_0x3b4e6e(0x39b)];for(const _0x53e1c5 of _0x53985b){if(!_0x53e1c5)continue;if(_0x53e1c5[_0x3b4e6e(0x256)][_0x3b4e6e(0x2c5)]()[_0x3b4e6e(0x1cb)]()===_0x3b4e6e(0x279))continue;if(_0x53e1c5[_0x3b4e6e(0x256)]['trim']()==='')continue;const _0x206231=_0x53e1c5[_0x3b4e6e(0x26f)][_0x3b4e6e(0x2c5)]()[_0x3b4e6e(0x1cb)]();if(_0x54ce0b[_0x3b4e6e(0x1ba)](_0x206231))continue;this[_0x3b4e6e(0x2e2)]=!![];break;}return this[_0x3b4e6e(0x2e2)];},ImageManager[_0x1ea0b5(0x1f5)]={'icons':{'all':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x34c)],'unlisted':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x26a)]},'lockedImgFilename':VisuMZ['CGGallery']['Settings'][_0x1ea0b5(0x23f)][_0x1ea0b5(0x28f)]},ImageManager[_0x1ea0b5(0x31f)]=function(){const _0x3b45f5=_0x1ea0b5;if(this[_0x3b45f5(0x1bf)])return this[_0x3b45f5(0x1bf)];if(ImageManager[_0x3b45f5(0x1f5)][_0x3b45f5(0x2d2)]!=='')return this['_cached_CGGallery_Image']=this['loadPicture'](ImageManager[_0x3b45f5(0x1f5)][_0x3b45f5(0x2d2)]),this['_cached_CGGallery_Image'];const _0x5aeb01=0x12c,_0xd4aa7b=0x12c,_0x5cf0da=new Bitmap(_0x5aeb01,_0xd4aa7b);return _0x5cf0da[_0x3b45f5(0x209)]=0x80,_0x5cf0da[_0x3b45f5(0x2ec)](0x96,0x96,0x78,_0x3b45f5(0x27d)),_0x5cf0da[_0x3b45f5(0x398)]=_0x3b45f5(0x2d4),_0x5cf0da[_0x3b45f5(0x2e0)]=!![],_0x5cf0da[_0x3b45f5(0x3ae)]=0x96,_0x5cf0da['outlineColor']=_0x3b45f5(0x366),_0x5cf0da['drawText']('X',0x0,0x0,0x12c,0x12c,_0x3b45f5(0x1d8)),_0x5cf0da[_0x3b45f5(0x209)]=0xff,_0x5cf0da[_0x3b45f5(0x317)]=![],this[_0x3b45f5(0x1bf)]=_0x5cf0da,this[_0x3b45f5(0x1bf)];},SoundManager['playViewCgImage']=function(){const _0x3450fa=_0x1ea0b5,_0x5bda34=VisuMZ[_0x3450fa(0x2a5)][_0x3450fa(0x375)][_0x3450fa(0x25e)],_0x19a0ce={'name':_0x5bda34[_0x3450fa(0x216)],'volume':_0x5bda34[_0x3450fa(0x22b)],'pitch':_0x5bda34[_0x3450fa(0x2de)],'pan':_0x5bda34[_0x3450fa(0x27e)]};AudioManager['playSe'](_0x19a0ce);},SoundManager[_0x1ea0b5(0x1ce)]=function(){const _0x5ebc5e=_0x1ea0b5,_0x3ccb61=VisuMZ[_0x5ebc5e(0x2a5)][_0x5ebc5e(0x375)][_0x5ebc5e(0x25e)],_0x57aa5f={'name':_0x3ccb61[_0x5ebc5e(0x367)],'volume':_0x3ccb61[_0x5ebc5e(0x34e)],'pitch':_0x3ccb61[_0x5ebc5e(0x225)],'pan':_0x3ccb61['changePan']};AudioManager[_0x5ebc5e(0x3a1)](_0x57aa5f);},TextManager[_0x1ea0b5(0x373)]=VisuMZ['CGGallery']['Settings'][_0x1ea0b5(0x387)][_0x1ea0b5(0x2b4)],TextManager[_0x1ea0b5(0x1f5)]={'category':{'all':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x371)],'unlisted':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)]['Vocab']['UnlistedCommandText']},'helpDesc':{'all':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x2a3)]['AllCommandDescription'],'unlisted':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x2a3)]['UnlistedCommandDescription'],'lockedImg':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x26b)]},'buttonAssist':{'border':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x393)],'gallery':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x31d)],'next':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x2a3)]['ButtonAssistVocab_Next'],'prev':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x2a3)]['ButtonAssistVocab_Prev'],'reset':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x212)],'zoom':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x29a)]}},SceneManager[_0x1ea0b5(0x1c2)]=function(){const _0x1fdf50=_0x1ea0b5;return this['_scene']&&this[_0x1fdf50(0x262)][_0x1fdf50(0x39f)]===Scene_Battle;},Game_System['CG_GALLERY']={'autoUnlock':VisuMZ['CGGallery']['Settings'][_0x1ea0b5(0x29b)][_0x1ea0b5(0x1c7)],'unlockAllVariations':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x29b)][_0x1ea0b5(0x25f)]},VisuMZ[_0x1ea0b5(0x2a5)]['Game_System_initialize']=Game_System['prototype']['initialize'],Game_System[_0x1ea0b5(0x369)][_0x1ea0b5(0x306)]=function(){const _0x77c899=_0x1ea0b5;VisuMZ[_0x77c899(0x2a5)][_0x77c899(0x246)][_0x77c899(0x383)](this),this[_0x77c899(0x27f)]();},Game_System[_0x1ea0b5(0x369)][_0x1ea0b5(0x27f)]=function(){const _0x5c9644=_0x1ea0b5;this[_0x5c9644(0x3b2)]={'shown':VisuMZ[_0x5c9644(0x2a5)][_0x5c9644(0x375)][_0x5c9644(0x387)]['ShowMainMenu'],'enabled':VisuMZ['CGGallery'][_0x5c9644(0x375)][_0x5c9644(0x387)][_0x5c9644(0x30b)]};},Game_System['prototype']['isMainMenuCgGalleryVisible']=function(){if(this['_cgGallery_MainMenu']===undefined)this['initCgGalleryMainMenu']();return this['_cgGallery_MainMenu']['shown'];},Game_System[_0x1ea0b5(0x369)]['setMainMenuCgGalleryVisible']=function(_0x493e6f){const _0x24e6e6=_0x1ea0b5;if(this['_cgGallery_MainMenu']===undefined)this[_0x24e6e6(0x27f)]();this[_0x24e6e6(0x3b2)][_0x24e6e6(0x1be)]=_0x493e6f;},Game_System[_0x1ea0b5(0x369)][_0x1ea0b5(0x342)]=function(){const _0x8863f5=_0x1ea0b5;if(this[_0x8863f5(0x3b2)]===undefined)this[_0x8863f5(0x27f)]();return this[_0x8863f5(0x3b2)]['enabled']&&this['hasCgUnlockedImage']();},Game_System['prototype'][_0x1ea0b5(0x257)]=function(_0x3be627){const _0x353049=_0x1ea0b5;if(this['_cgGallery_MainMenu']===undefined)this[_0x353049(0x27f)]();this[_0x353049(0x3b2)][_0x353049(0x296)]=_0x3be627;},Game_System['prototype'][_0x1ea0b5(0x368)]=function(){const _0x33054c=_0x1ea0b5;return ConfigManager[_0x33054c(0x37f)]()||VisuMZ[_0x33054c(0x2a5)]['DefaultUnlocks']()['length']>0x0;},Game_System[_0x1ea0b5(0x369)][_0x1ea0b5(0x2f2)]=function(_0x2fc8c1,_0x541579){const _0x57c19e=_0x1ea0b5;if(VisuMZ[_0x57c19e(0x2a5)][_0x57c19e(0x341)]()['includes'](_0x2fc8c1))return!![];if(_0x541579&&Game_System[_0x57c19e(0x1f5)][_0x57c19e(0x264)])return!![];if($gameTemp[_0x57c19e(0x295)]&&$gameTemp[_0x57c19e(0x2be)]())return!![];return ConfigManager[_0x57c19e(0x312)][_0x57c19e(0x1ba)](_0x2fc8c1);},Game_System[_0x1ea0b5(0x369)]['unlockImageForCgGallery']=function(_0x571949){const _0x1849b9=_0x1ea0b5;if(ConfigManager['cgGalleryUnlocks'][_0x1849b9(0x1ba)](_0x571949))return;ConfigManager[_0x1849b9(0x312)][_0x1849b9(0x2c7)](_0x571949),ConfigManager['cgGalleryUnlocks'][_0x1849b9(0x238)](),ConfigManager['save']();},Game_System[_0x1ea0b5(0x369)][_0x1ea0b5(0x346)]=function(_0x153b83){const _0x2ef664=_0x1ea0b5;return _0x153b83=_0x153b83||'all',VisuMZ[_0x2ef664(0x2a5)][_0x2ef664(0x234)](_0x153b83);},Game_System['prototype'][_0x1ea0b5(0x320)]=function(_0x298a73){const _0x43e3a5=_0x1ea0b5;_0x298a73=_0x298a73||_0x43e3a5(0x391);let _0x28508d=0x0;const _0x443795=VisuMZ['CGGallery']['Settings'][_0x43e3a5(0x39b)];for(const _0x4133fd of _0x443795){if(_0x43e3a5(0x337)!==_0x43e3a5(0x2ca)){if(!_0x4133fd)continue;if(_0x4133fd['Filename'][_0x43e3a5(0x2c5)]()[_0x43e3a5(0x1cb)]()==='untitled')continue;if(_0x4133fd['Filename'][_0x43e3a5(0x1cb)]()==='')continue;if(!VisuMZ[_0x43e3a5(0x2a5)]['listingMatchesCategory'](_0x4133fd,_0x298a73))continue;if(this[_0x43e3a5(0x2f2)](_0x4133fd[_0x43e3a5(0x256)]))_0x28508d++;else continue;for(const _0x277344 of _0x4133fd[_0x43e3a5(0x2bc)]){if(_0x277344['toLowerCase']()[_0x43e3a5(0x1cb)]()==='untitled')continue;if(_0x277344['trim']()==='')continue;if(this[_0x43e3a5(0x2f2)](_0x277344,!![]))_0x28508d++;}}else return _0x43e3a5(0x1c1);}return _0x28508d;},Game_System['prototype'][_0x1ea0b5(0x2ad)]=function(_0x2c77cb){const _0x5bfaa2=_0x1ea0b5;_0x2c77cb=_0x2c77cb||'all';const _0x1a5b39=this[_0x5bfaa2(0x346)](_0x2c77cb);let _0x10c896=this[_0x5bfaa2(0x320)](_0x2c77cb);return _0x10c896/_0x1a5b39;},VisuMZ['CGGallery'][_0x1ea0b5(0x35e)]=Game_Picture[_0x1ea0b5(0x369)][_0x1ea0b5(0x233)],Game_Picture[_0x1ea0b5(0x369)][_0x1ea0b5(0x233)]=function(_0xb97f77,_0x52077c,_0x295ee8,_0x179132,_0x4fe6c5,_0x115808,_0xb17c9d,_0xf43245){const _0x56f55f=_0x1ea0b5;VisuMZ['CGGallery'][_0x56f55f(0x35e)][_0x56f55f(0x383)](this,_0xb97f77,_0x52077c,_0x295ee8,_0x179132,_0x4fe6c5,_0x115808,_0xb17c9d,_0xf43245),Game_System[_0x56f55f(0x1f5)][_0x56f55f(0x34a)]&&$gameSystem[_0x56f55f(0x22c)](_0xb97f77);},VisuMZ['CGGallery'][_0x1ea0b5(0x220)]=Scene_Title['prototype'][_0x1ea0b5(0x316)],Scene_Title[_0x1ea0b5(0x369)]['createCommandWindow']=function(){const _0x1596bd=_0x1ea0b5;VisuMZ[_0x1596bd(0x2a5)][_0x1596bd(0x220)][_0x1596bd(0x383)](this),this[_0x1596bd(0x2f9)][_0x1596bd(0x28c)](_0x1596bd(0x2fe),this[_0x1596bd(0x2a7)][_0x1596bd(0x334)](this));},Scene_Title[_0x1ea0b5(0x369)][_0x1ea0b5(0x2a7)]=function(){const _0x19e60f=_0x1ea0b5;this[_0x19e60f(0x2f9)][_0x19e60f(0x23d)](),SceneManager[_0x19e60f(0x2c7)](Scene_CG_Gallery);},VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x228)]=Scene_Menu['prototype'][_0x1ea0b5(0x316)],Scene_Menu['prototype'][_0x1ea0b5(0x316)]=function(){const _0x435398=_0x1ea0b5;VisuMZ[_0x435398(0x2a5)][_0x435398(0x228)][_0x435398(0x383)](this);const _0x303b39=this['_commandWindow'];_0x303b39[_0x435398(0x28c)]('cgGallery',this[_0x435398(0x2a7)][_0x435398(0x334)](this));},Scene_Menu['prototype'][_0x1ea0b5(0x2a7)]=function(){const _0x378958=_0x1ea0b5;SceneManager[_0x378958(0x2c7)](Scene_CG_Gallery);};function Scene_CG_Gallery(){this['initialize'](...arguments);}Scene_CG_Gallery[_0x1ea0b5(0x369)]=Object['create'](Scene_MenuBase[_0x1ea0b5(0x369)]),Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x39f)]=Scene_CG_Gallery,Scene_CG_Gallery[_0x1ea0b5(0x355)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x381)],Scene_CG_Gallery[_0x1ea0b5(0x35d)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x20a)],Scene_CG_Gallery[_0x1ea0b5(0x2cd)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)]['GalleryWindow_BgType'],Scene_CG_Gallery[_0x1ea0b5(0x332)]=VisuMZ['CGGallery'][_0x1ea0b5(0x375)][_0x1ea0b5(0x29b)]['MoveDistance'],Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x306)]=function(){const _0x394cb0=_0x1ea0b5;Scene_MenuBase['prototype'][_0x394cb0(0x306)]['call'](this),this[_0x394cb0(0x2d8)]();},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2d8)]=function(){const _0x399492=_0x1ea0b5;this[_0x399492(0x1c8)]=![],this[_0x399492(0x38d)]=!![],this[_0x399492(0x254)]=0x0,this[_0x399492(0x304)]=[];},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x241)]=function(){const _0x28d1f2=_0x1ea0b5;Scene_MenuBase[_0x28d1f2(0x369)][_0x28d1f2(0x241)][_0x28d1f2(0x383)](this),this[_0x28d1f2(0x1c8)]&&this[_0x28d1f2(0x1f4)]();},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x285)]=function(){const _0x2b9933=_0x1ea0b5;Scene_MenuBase[_0x2b9933(0x369)]['createPageButtons'][_0x2b9933(0x383)](this),this[_0x2b9933(0x2af)][_0x2b9933(0x3ad)](this['processVariationChange']['bind'](this,![])),this[_0x2b9933(0x2f4)][_0x2b9933(0x3ad)](this[_0x2b9933(0x3af)][_0x2b9933(0x334)](this,!![])),this[_0x2b9933(0x3a3)]();},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x350)]=function(){return![];return!![];},Scene_MenuBase['prototype'][_0x1ea0b5(0x208)]=function(){const _0x37525d=_0x1ea0b5;return this[_0x37525d(0x1c8)]&&this['_viewModeVisible'];},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2eb)]=function(){const _0x1a4862=_0x1ea0b5;Scene_MenuBase['prototype'][_0x1a4862(0x2eb)][_0x1a4862(0x383)](this),this[_0x1a4862(0x2c0)](),this[_0x1a4862(0x1f2)](),this[_0x1a4862(0x25d)]();},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2c0)]=function(){const _0x4c1d7a=_0x1ea0b5;Scene_MenuBase[_0x4c1d7a(0x369)][_0x4c1d7a(0x2c0)][_0x4c1d7a(0x383)](this);const _0xeb1632=this[_0x4c1d7a(0x273)];_0xeb1632[_0x4c1d7a(0x2cf)](Scene_CG_Gallery[_0x4c1d7a(0x355)]);},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x1d2)]=function(){const _0x40adb5=_0x1ea0b5;if(VisuMZ['CGGallery'][_0x40adb5(0x375)]['Window'][_0x40adb5(0x1d6)]){if(_0x40adb5(0x1e2)!==_0x40adb5(0x339))return VisuMZ[_0x40adb5(0x2a5)]['Settings'][_0x40adb5(0x23f)][_0x40adb5(0x1d6)][_0x40adb5(0x383)](this);else _0x5b3d90['ConvertParams'](_0x14e012,_0x56e702),_0x32dfcd['_cgGalleryFullUnlock']=![],_0x2ae1bd[_0x40adb5(0x312)]=[],_0x402741[_0x40adb5(0x330)]();}const _0x28ecdc=0x0,_0x296036=this[_0x40adb5(0x1bd)](),_0x233245=Graphics[_0x40adb5(0x2ee)],_0x4de6cb=this['helpAreaHeight']();return new Rectangle(_0x28ecdc,_0x296036,_0x233245,_0x4de6cb);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x1f2)]=function(){const _0x134ba6=_0x1ea0b5,_0x8b4c4=this[_0x134ba6(0x250)](),_0x1d19d9=new Window_CG_Category(_0x8b4c4);_0x1d19d9[_0x134ba6(0x3b3)](this['_helpWindow']),_0x1d19d9['setHandler'](_0x134ba6(0x396),this['commandCategory'][_0x134ba6(0x334)](this)),_0x1d19d9['setHandler'](_0x134ba6(0x30a),this[_0x134ba6(0x31a)][_0x134ba6(0x334)](this)),this[_0x134ba6(0x1dc)](_0x1d19d9),this[_0x134ba6(0x2d0)]=_0x1d19d9,_0x1d19d9[_0x134ba6(0x2cf)](Scene_CG_Gallery[_0x134ba6(0x35d)]);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x250)]=function(){const _0x23360f=_0x1ea0b5;if(VisuMZ[_0x23360f(0x2a5)][_0x23360f(0x375)][_0x23360f(0x23f)]['CategoryWindow_RectJS']){if(_0x23360f(0x271)!=='XyzNx')this[_0x23360f(0x3af)](![]);else return VisuMZ[_0x23360f(0x2a5)][_0x23360f(0x375)][_0x23360f(0x23f)]['CategoryWindow_RectJS'][_0x23360f(0x383)](this);}const _0xbb4ee4=Graphics[_0x23360f(0x2ee)],_0x5897ea=this[_0x23360f(0x2a1)](0x1,![]),_0x447653=0x0,_0x4ec63b=this['mainAreaTop']();return new Rectangle(_0x447653,_0x4ec63b,_0xbb4ee4,_0x5897ea);},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x25d)]=function(){const _0x12ba95=_0x1ea0b5,_0x1be2b7=this[_0x12ba95(0x207)](),_0x148414=new Window_CG_Gallery(_0x1be2b7);_0x148414[_0x12ba95(0x1e1)](),_0x148414[_0x12ba95(0x2d5)](),this[_0x12ba95(0x2d0)][_0x12ba95(0x1de)](_0x148414),_0x148414['setHelpWindow'](this['_helpWindow']),_0x148414['setHandler'](_0x12ba95(0x35f),this[_0x12ba95(0x275)][_0x12ba95(0x334)](this)),_0x148414[_0x12ba95(0x28c)](_0x12ba95(0x30a),this[_0x12ba95(0x34b)][_0x12ba95(0x334)](this)),this['addWindow'](_0x148414),this[_0x12ba95(0x269)]=_0x148414,_0x148414[_0x12ba95(0x2cf)](Scene_CG_Gallery['CG_WINDOW_BGTYPE']);},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x207)]=function(){const _0x2ab481=_0x1ea0b5;if(VisuMZ[_0x2ab481(0x2a5)][_0x2ab481(0x375)][_0x2ab481(0x23f)][_0x2ab481(0x23a)])return VisuMZ['CGGallery'][_0x2ab481(0x375)][_0x2ab481(0x23f)][_0x2ab481(0x23a)]['call'](this);const _0x6bfec8=Graphics[_0x2ab481(0x2ee)],_0x13e5c7=this[_0x2ab481(0x2e1)]()-this['calcWindowHeight'](0x1,![]),_0x485c6e=0x0,_0x32a87d=this[_0x2ab481(0x1f9)]()+this[_0x2ab481(0x2a1)](0x1,![]);return new Rectangle(_0x485c6e,_0x32a87d,_0x6bfec8,_0x13e5c7);},Scene_CG_Gallery[_0x1ea0b5(0x369)]['buttonAssistKey1']=function(){const _0x578548=_0x1ea0b5;if(this[_0x578548(0x1c8)]){if(_0x578548(0x2bb)!==_0x578548(0x2bb))this[_0x578548(0x1f4)]();else return TextManager[_0x578548(0x38a)](_0x578548(0x1fc),_0x578548(0x263));}else{if(_0x578548(0x2db)!==_0x578548(0x2db)){_0x3eb8ee[_0x578548(0x369)][_0x578548(0x2c0)][_0x578548(0x383)](this);const _0x5e1700=this['_helpWindow'];_0x5e1700[_0x578548(0x2cf)](_0x545c98['HELP_WINDOW_BGTYPE']);}else return Scene_MenuBase[_0x578548(0x369)][_0x578548(0x1c3)][_0x578548(0x383)](this);}},Scene_CG_Gallery[_0x1ea0b5(0x369)]['buttonAssistKey2']=function(){const _0x264842=_0x1ea0b5;if(this[_0x264842(0x1c8)]){if(_0x264842(0x205)===_0x264842(0x37b))this[_0x264842(0x269)]['select'](0x0);else return TextManager['getInputButtonString'](_0x264842(0x24b));}else return Scene_MenuBase[_0x264842(0x369)]['buttonAssistKey2'][_0x264842(0x383)](this);},Scene_CG_Gallery[_0x1ea0b5(0x369)]['buttonAssistKey3']=function(){const _0x3eef12=_0x1ea0b5;return this[_0x3eef12(0x1c8)]?'WpEms'!==_0x3eef12(0x2f7)?TextManager['getInputButtonString'](_0x3eef12(0x303)):this[_0x3eef12(0x1c8)]?_0x18a772[_0x3eef12(0x1f5)][_0x3eef12(0x3b0)][_0x3eef12(0x33e)]:_0x33aef3[_0x3eef12(0x369)][_0x3eef12(0x288)][_0x3eef12(0x383)](this):Scene_MenuBase['prototype']['buttonAssistKey3'][_0x3eef12(0x383)](this);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2ed)]=function(){const _0x770899=_0x1ea0b5;return this[_0x770899(0x1c8)]?TextManager[_0x770899(0x1f5)][_0x770899(0x3b0)][_0x770899(0x21d)]:Scene_MenuBase['prototype'][_0x770899(0x2ed)][_0x770899(0x383)](this);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2ef)]=function(){const _0x586b28=_0x1ea0b5;return this[_0x586b28(0x1c8)]?TextManager[_0x586b28(0x1f5)][_0x586b28(0x3b0)][_0x586b28(0x20f)]:Scene_MenuBase[_0x586b28(0x369)][_0x586b28(0x2ef)][_0x586b28(0x383)](this);},Scene_CG_Gallery[_0x1ea0b5(0x369)]['buttonAssistText3']=function(){const _0x5c2d8b=_0x1ea0b5;return this[_0x5c2d8b(0x1c8)]?_0x5c2d8b(0x35a)===_0x5c2d8b(0x305)?_0x3bf562[_0x5c2d8b(0x2a5)][_0x5c2d8b(0x375)][_0x5c2d8b(0x331)][_0x5c2d8b(0x272)]:TextManager[_0x5c2d8b(0x1f5)][_0x5c2d8b(0x3b0)][_0x5c2d8b(0x33e)]:Scene_MenuBase[_0x5c2d8b(0x369)][_0x5c2d8b(0x288)][_0x5c2d8b(0x383)](this);},Scene_CG_Gallery[_0x1ea0b5(0x369)]['buttonAssistText4']=function(){const _0x56065e=_0x1ea0b5;if(this[_0x56065e(0x1c8)])return'vwDIF'!==_0x56065e(0x323)?this[_0x56065e(0x254)]>=this[_0x56065e(0x304)][_0x56065e(0x361)]-0x1?TextManager[_0x56065e(0x1f5)][_0x56065e(0x3b0)][_0x56065e(0x2ac)]:_0x56065e(0x370)===_0x56065e(0x370)?TextManager[_0x56065e(0x1f5)]['buttonAssist'][_0x56065e(0x348)]:this[_0x56065e(0x254)]<=0x0?_0x4d1d59[_0x56065e(0x1f5)][_0x56065e(0x3b0)]['gallery']:_0x559dcb[_0x56065e(0x1f5)][_0x56065e(0x3b0)][_0x56065e(0x237)]:this[_0x56065e(0x1c8)]&&this[_0x56065e(0x38d)];else{if(_0x56065e(0x1f7)!=='aZQrO'){_0x5e877f[_0x56065e(0x369)]['updateHelp'][_0x56065e(0x383)](this);const _0x146ad3=this[_0x56065e(0x3ab)]();_0x146ad3&&(_0x557eea[_0x56065e(0x2f2)](_0x146ad3[_0x56065e(0x256)])?this[_0x56065e(0x273)]['setText'](_0x146ad3[_0x56065e(0x25a)]||''):this['_helpWindow']['setText'](_0x38ab81[_0x56065e(0x1f5)]['helpDesc'][_0x56065e(0x326)]));}else return Scene_MenuBase['prototype']['buttonAssistText4'][_0x56065e(0x383)](this);}},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x26e)]=function(){const _0x5de9c2=_0x1ea0b5;if(this[_0x5de9c2(0x1c8)]){if(this[_0x5de9c2(0x254)]<=0x0)return TextManager[_0x5de9c2(0x1f5)][_0x5de9c2(0x3b0)][_0x5de9c2(0x2ac)];else{if(_0x5de9c2(0x338)!==_0x5de9c2(0x338))_0x2161c6['x']=this[_0x5de9c2(0x30c)]+_0x46abee[_0x5de9c2(0x31b)](_0x30568c[_0x5de9c2(0x2c9)]/0x2);else return TextManager[_0x5de9c2(0x1f5)][_0x5de9c2(0x3b0)][_0x5de9c2(0x237)];}}else{if(_0x5de9c2(0x276)===_0x5de9c2(0x1e7))_0x443d7e['unlockImageForCgGallery'](_0x167f9a);else return Scene_MenuBase[_0x5de9c2(0x369)][_0x5de9c2(0x26e)][_0x5de9c2(0x383)](this);}},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x274)]=function(){const _0x476bf4=_0x1ea0b5;Scene_MenuBase['prototype'][_0x476bf4(0x274)][_0x476bf4(0x383)](this),this[_0x476bf4(0x219)](this[_0x476bf4(0x347)]()),this['createCustomBackgroundImages'](),this[_0x476bf4(0x2c6)](),this['createViewSprite']();},Scene_CG_Gallery['prototype']['getBackgroundOpacity']=function(){const _0x1132c5=_0x1ea0b5;return VisuMZ['CGGallery'][_0x1132c5(0x375)][_0x1132c5(0x331)][_0x1132c5(0x272)];},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x298)]=function(){const _0x5da819=_0x1ea0b5,_0x3e5418=VisuMZ[_0x5da819(0x2a5)][_0x5da819(0x375)][_0x5da819(0x331)];_0x3e5418&&(_0x3e5418['BgFilename1']!==''||_0x3e5418[_0x5da819(0x261)]!=='')&&(_0x5da819(0x33c)==='MsXoq'?(this[_0x5da819(0x2ba)]=new Sprite(ImageManager['loadTitle1'](_0x3e5418[_0x5da819(0x358)])),this['_backSprite2']=new Sprite(ImageManager[_0x5da819(0x2b6)](_0x3e5418[_0x5da819(0x261)])),this['addChild'](this[_0x5da819(0x2ba)]),this[_0x5da819(0x236)](this['_backSprite2']),this['_backSprite1']['bitmap'][_0x5da819(0x35b)](this['adjustSprite'][_0x5da819(0x334)](this,this[_0x5da819(0x2ba)])),this[_0x5da819(0x39c)][_0x5da819(0x260)][_0x5da819(0x35b)](this['adjustSprite'][_0x5da819(0x334)](this,this[_0x5da819(0x39c)]))):_0x3d91de['unlockImageForCgGallery'](_0x2cff0f));},Scene_CG_Gallery[_0x1ea0b5(0x369)]['createBlackBackgroundImage']=function(){const _0x37f956=_0x1ea0b5;this[_0x37f956(0x2cb)]=new Sprite(),this['addChild'](this[_0x37f956(0x2cb)]),this[_0x37f956(0x2cb)][_0x37f956(0x260)]=new Bitmap(0x1,0x1),this[_0x37f956(0x2cb)][_0x37f956(0x260)][_0x37f956(0x300)](0x0,0x0,0x1,0x1,_0x37f956(0x2df)),this[_0x37f956(0x2cb)]['scale']['x']=Graphics[_0x37f956(0x1e4)],this['_blackBgSprite'][_0x37f956(0x293)]['y']=Graphics[_0x37f956(0x395)],this[_0x37f956(0x2cb)][_0x37f956(0x378)]=0x0;},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x311)]=function(){const _0xd3cf48=_0x1ea0b5,_0x33b5cf=new Sprite();_0x33b5cf['bitmap']=new Bitmap(0x64,0x64),_0x33b5cf[_0xd3cf48(0x378)]=0x0,this[_0xd3cf48(0x357)]=_0x33b5cf,this[_0xd3cf48(0x236)](_0x33b5cf),this[_0xd3cf48(0x32b)](_0x33b5cf);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x1db)]=function(_0x2649ce){this['scaleSprite'](_0x2649ce),this['centerSprite'](_0x2649ce);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x32b)]=function(_0x3c24d6){const _0x1ce552=_0x1ea0b5;this[_0x1ce552(0x211)](_0x3c24d6),this[_0x1ce552(0x34d)](_0x3c24d6);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x211)]=function(_0x10be05){const _0x2d6bb1=_0x1ea0b5,_0x5e01d1=Graphics[_0x2d6bb1(0x1e4)]/_0x10be05[_0x2d6bb1(0x260)][_0x2d6bb1(0x1e4)],_0x3b6092=Graphics[_0x2d6bb1(0x395)]/_0x10be05[_0x2d6bb1(0x260)][_0x2d6bb1(0x395)],_0x1e49df=Math[_0x2d6bb1(0x2c1)](_0x5e01d1,_0x3b6092,0x1);_0x10be05[_0x2d6bb1(0x293)]['x']=_0x1e49df,_0x10be05[_0x2d6bb1(0x293)]['y']=_0x1e49df;},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2ce)]=function(){const _0x5553f7=_0x1ea0b5;this['_categoryWindow'][_0x5553f7(0x1e1)](),this[_0x5553f7(0x269)]['activate'](),this['_galleryWindow'][_0x5553f7(0x379)](),this[_0x5553f7(0x269)][_0x5553f7(0x390)]()<0x0&&this[_0x5553f7(0x269)]['select'](0x0);},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x34b)]=function(){const _0x458b7a=_0x1ea0b5;this['_categoryWindow'][_0x458b7a(0x218)](),this[_0x458b7a(0x269)]['deactivate']();},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x275)]=function(){const _0x1041bc=_0x1ea0b5,_0x244e3a=this[_0x1041bc(0x269)][_0x1041bc(0x3ab)]();if(!_0x244e3a){this[_0x1041bc(0x269)][_0x1041bc(0x218)]();return;}this['_variationList']=[_0x244e3a[_0x1041bc(0x256)]];for(const _0x244362 of _0x244e3a[_0x1041bc(0x2bc)]){if(_0x244362['toLowerCase']()[_0x1041bc(0x1cb)]()===_0x1041bc(0x279))continue;if(_0x244362[_0x1041bc(0x1cb)]()==='')continue;$gameSystem[_0x1041bc(0x2f2)](_0x244362,!![])&&this['_variationList']['push'](_0x244362);}this['_viewSprite'][_0x1041bc(0x260)]=ImageManager[_0x1041bc(0x27c)](_0x244e3a[_0x1041bc(0x256)]),this['_viewSprite']['bitmap'][_0x1041bc(0x35b)](this[_0x1041bc(0x281)]['bind'](this)),Input[_0x1041bc(0x2f5)](),TouchInput[_0x1041bc(0x2f5)]();},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x281)]=function(){const _0xef136=_0x1ea0b5;this['_viewMode']=!![],this[_0xef136(0x254)]=0x0,this[_0xef136(0x38d)]=!![],this[_0xef136(0x273)]['hide'](),this[_0xef136(0x2d0)][_0xef136(0x21a)](),this[_0xef136(0x269)][_0xef136(0x21a)](),this[_0xef136(0x32b)](this[_0xef136(0x357)]),this[_0xef136(0x357)]['opacity']=0xff,this[_0xef136(0x2cb)][_0xef136(0x378)]=0xff;},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x282)]=function(){const _0x354aa2=_0x1ea0b5;this[_0x354aa2(0x1c8)]=![],this[_0x354aa2(0x254)]=0x0,this[_0x354aa2(0x38d)]=![],this[_0x354aa2(0x3a3)](),this['_helpWindow'][_0x354aa2(0x233)](),this[_0x354aa2(0x2d0)][_0x354aa2(0x233)](),this[_0x354aa2(0x269)][_0x354aa2(0x233)](),this['_galleryWindow']['activate']();if(this[_0x354aa2(0x1eb)])this[_0x354aa2(0x1eb)]['visible']=!![];if(this[_0x354aa2(0x2f8)])this['_cancelButton'][_0x354aa2(0x28d)]=!![];this[_0x354aa2(0x357)]['opacity']=0x0,this[_0x354aa2(0x2cb)]['opacity']=0x0,Input[_0x354aa2(0x2f5)](),TouchInput[_0x354aa2(0x2f5)]();},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x1f4)]=function(){const _0x44d54c=_0x1ea0b5,_0x112a24=0x14;if(Input[_0x44d54c(0x301)](_0x44d54c(0x30a)))_0x44d54c(0x1ef)!=='ZMUeO'?this['drawItemStyleIconText'](_0x50b37d):this['processViewModeCancel']();else{if(Input[_0x44d54c(0x301)]('ok')){if(_0x44d54c(0x33b)!==_0x44d54c(0x33b)){_0x53f731[_0x44d54c(0x2a5)][_0x44d54c(0x228)][_0x44d54c(0x383)](this);const _0x49d111=this[_0x44d54c(0x2f9)];_0x49d111[_0x44d54c(0x28c)](_0x44d54c(0x2fe),this[_0x44d54c(0x2a7)][_0x44d54c(0x334)](this));}else this['processViewModeOk']();}else{if(Input[_0x44d54c(0x301)]('tab'))this[_0x44d54c(0x292)]();else{if(Input[_0x44d54c(0x301)](_0x44d54c(0x24b)))this[_0x44d54c(0x2a0)]();else{if(Input[_0x44d54c(0x301)](_0x44d54c(0x1fc))||TouchInput[_0x44d54c(0x20b)]<=-_0x112a24)this[_0x44d54c(0x280)](!![]);else{if(Input[_0x44d54c(0x301)]('pagedown')||TouchInput[_0x44d54c(0x20b)]>=_0x112a24)this['processViewModeScale'](![]);else{if(Input[_0x44d54c(0x1da)]>0x0)_0x44d54c(0x2ff)!=='IUOYB'?(_0x59926a[_0x44d54c(0x369)][_0x44d54c(0x285)][_0x44d54c(0x383)](this),this['_pageupButton'][_0x44d54c(0x3ad)](this['processVariationChange']['bind'](this,![])),this[_0x44d54c(0x2f4)][_0x44d54c(0x3ad)](this[_0x44d54c(0x3af)]['bind'](this,!![])),this[_0x44d54c(0x3a3)]()):this[_0x44d54c(0x39a)](Input[_0x44d54c(0x1da)]);else{if(TouchInput[_0x44d54c(0x313)]())this[_0x44d54c(0x380)]();else{if(TouchInput[_0x44d54c(0x333)]()){if(_0x44d54c(0x1f6)===_0x44d54c(0x2b2))return _0x2cb636['TEXT_ALIGN'];else this[_0x44d54c(0x22e)]();}}}}}}}}}},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x217)]=function(){const _0x167d5a=_0x1ea0b5;this[_0x167d5a(0x254)]<=0x0?'vSvlz'===_0x167d5a(0x1d5)?_0x21a770=_0x56d0c5[_0x167d5a(0x31b)]((_0x228f87-_0x276e78)/_0x5da758*_0x523ce9):(SoundManager[_0x167d5a(0x2dc)](),this[_0x167d5a(0x282)]()):this['processVariationChange'](![]);},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x3af)]=function(_0x432fd6){const _0x3bfa84=_0x1ea0b5,_0x736c72=this[_0x3bfa84(0x254)];this['_variationIndex']+=_0x432fd6?0x1:-0x1,this[_0x3bfa84(0x254)]=this[_0x3bfa84(0x254)][_0x3bfa84(0x38f)](0x0,this['_variationList'][_0x3bfa84(0x361)]-0x1);if(_0x736c72!==this[_0x3bfa84(0x254)]){const _0x27d154=this['_variationList'][this[_0x3bfa84(0x254)]];this[_0x3bfa84(0x357)][_0x3bfa84(0x260)]=ImageManager[_0x3bfa84(0x27c)](_0x27d154),SoundManager[_0x3bfa84(0x1ce)](),this[_0x3bfa84(0x32b)](this[_0x3bfa84(0x357)]);}},Scene_CG_Gallery[_0x1ea0b5(0x369)]['processViewModeOk']=function(){const _0x12fcbb=_0x1ea0b5;this[_0x12fcbb(0x254)]>=this[_0x12fcbb(0x304)][_0x12fcbb(0x361)]-0x1?(SoundManager['playCancel'](),this[_0x12fcbb(0x282)]()):this[_0x12fcbb(0x3af)](!![]);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x292)]=function(){const _0x52b198=_0x1ea0b5;SoundManager[_0x52b198(0x3a0)](),this[_0x52b198(0x32b)](this[_0x52b198(0x357)]),this[_0x52b198(0x357)][_0x52b198(0x378)]=0xff,this['_blackBgSprite'][_0x52b198(0x378)]=0xff;},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2a0)]=function(){const _0x5c2acd=_0x1ea0b5;SoundManager[_0x5c2acd(0x3a0)](),this[_0x5c2acd(0x38d)]=!this['_viewModeVisible'];this[_0x5c2acd(0x1eb)]&&(this[_0x5c2acd(0x1eb)][_0x5c2acd(0x28d)]=this['_viewModeVisible']);if(this[_0x5c2acd(0x2f8)]){if(_0x5c2acd(0x266)!==_0x5c2acd(0x310))this[_0x5c2acd(0x2f8)][_0x5c2acd(0x28d)]=this[_0x5c2acd(0x38d)];else{const _0xfd11af=this[_0x5c2acd(0x335)](_0x41fd91);if(_0xfd11af[_0x5c2acd(0x206)](/\\I\[(\d+)\]/i)){const _0x452b2e=this['itemLineRect'](_0xe9f9ab),_0x647535=this[_0x5c2acd(0x290)](_0xfd11af)[_0x5c2acd(0x1e4)];return _0x647535<=_0x452b2e[_0x5c2acd(0x1e4)]?'iconText':'icon';}}}this[_0x5c2acd(0x2af)]&&this[_0x5c2acd(0x2f4)]&&(this['_pageupButton'][_0x5c2acd(0x28d)]=this['_viewModeVisible'],this[_0x5c2acd(0x2f4)][_0x5c2acd(0x28d)]=this[_0x5c2acd(0x38d)]);},Scene_CG_Gallery['prototype'][_0x1ea0b5(0x280)]=function(_0x37ef57){const _0x330892=_0x1ea0b5;let _0x5a98d9=this[_0x330892(0x357)][_0x330892(0x293)]['x'];const _0x1dcbd5=_0x5a98d9;_0x5a98d9+=_0x37ef57?0.1:-0.1,_0x5a98d9=Number(_0x5a98d9[_0x330892(0x21f)](0x1)),this[_0x330892(0x357)][_0x330892(0x293)]['x']=_0x5a98d9[_0x330892(0x38f)](0.1,0x4),this[_0x330892(0x357)][_0x330892(0x293)]['y']=_0x5a98d9['clamp'](0.1,0x4);if(_0x1dcbd5!==this[_0x330892(0x357)][_0x330892(0x293)]['x']){if('Ihhzz'===_0x330892(0x1c9))SoundManager[_0x330892(0x2c2)]();else{this[_0x330892(0x335)](_0x550ce8)[_0x330892(0x206)](/\\I\[(\d+)\]/i);const _0x271162=_0x14744c(_0x36a3f7['$1'])||0x0,_0x4c5cfe=this['itemLineRect'](_0xab1d23),_0x216ce0=_0x4c5cfe['x']+_0x128236[_0x330892(0x31b)]((_0x4c5cfe[_0x330892(0x1e4)]-_0xcf5b8c[_0x330892(0x2fc)])/0x2),_0x4f85a2=_0x4c5cfe['y']+(_0x4c5cfe['height']-_0xecb538[_0x330892(0x37d)])/0x2;this[_0x330892(0x327)](_0x271162,_0x216ce0,_0x4f85a2);}}},Scene_CG_Gallery['prototype']['processViewModeMove']=function(_0x4d2611){const _0x3c6df1=_0x1ea0b5,_0x344fe3=Scene_CG_Gallery[_0x3c6df1(0x332)];switch(_0x4d2611){case 0x7:case 0x4:case 0x1:this['_viewSprite']['x']-=_0x344fe3;break;case 0x9:case 0x6:case 0x3:this[_0x3c6df1(0x357)]['x']+=_0x344fe3;break;}switch(_0x4d2611){case 0x1:case 0x2:case 0x3:this[_0x3c6df1(0x357)]['y']+=_0x344fe3;break;case 0x7:case 0x8:case 0x9:this['_viewSprite']['y']-=_0x344fe3;break;}this[_0x3c6df1(0x357)]['x']=this[_0x3c6df1(0x357)]['x'][_0x3c6df1(0x38f)](0x0,Graphics[_0x3c6df1(0x1e4)]),this[_0x3c6df1(0x357)]['y']=this[_0x3c6df1(0x357)]['y'][_0x3c6df1(0x38f)](0x0,Graphics[_0x3c6df1(0x395)]);},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x380)]=function(){const _0x1f2707=_0x1ea0b5,_0x323b44=Math['round'](this[_0x1f2707(0x2f8)][_0x1f2707(0x1e4)]*1.3);TouchInput['x']>_0x323b44&&TouchInput['x']<Graphics[_0x1f2707(0x1e4)]-_0x323b44&&(TouchInput['y']>_0x323b44&&TouchInput['y']<Graphics[_0x1f2707(0x395)]-_0x323b44&&(this[_0x1f2707(0x357)]['x']=TouchInput['x']['clamp'](0x0,Graphics[_0x1f2707(0x1e4)]),this[_0x1f2707(0x357)]['y']=TouchInput['y']['clamp'](0x0,Graphics[_0x1f2707(0x395)])));},Scene_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x22e)]=function(){const _0x7363a5=_0x1ea0b5,_0x1bc7ab=Math[_0x7363a5(0x25b)](this[_0x7363a5(0x2f8)][_0x7363a5(0x1e4)]*1.05);TouchInput['x']>_0x1bc7ab&&TouchInput['x']<Graphics[_0x7363a5(0x1e4)]-_0x1bc7ab&&((TouchInput['y']<_0x1bc7ab||TouchInput['y']>Graphics[_0x7363a5(0x395)]-_0x1bc7ab)&&this[_0x7363a5(0x2a0)]());},VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x1f8)]=Window_MenuCommand[_0x1ea0b5(0x369)][_0x1ea0b5(0x318)],Window_MenuCommand[_0x1ea0b5(0x369)]['addOriginalCommands']=function(){const _0x2a6fa5=_0x1ea0b5;VisuMZ['CGGallery']['Window_MenuCommand_addOriginalCommands'][_0x2a6fa5(0x383)](this),this[_0x2a6fa5(0x365)]();},Window_MenuCommand[_0x1ea0b5(0x369)][_0x1ea0b5(0x365)]=function(){const _0x2b16fc=_0x1ea0b5;if(!this[_0x2b16fc(0x36f)]())return;if(!this[_0x2b16fc(0x2e6)]())return;const _0xc4efea=TextManager[_0x2b16fc(0x373)],_0x5a87ae=this[_0x2b16fc(0x1c5)]();this[_0x2b16fc(0x201)](_0xc4efea,_0x2b16fc(0x2fe),_0x5a87ae);},Window_MenuCommand[_0x1ea0b5(0x369)][_0x1ea0b5(0x36f)]=function(){const _0x372ea9=_0x1ea0b5;return Imported[_0x372ea9(0x2b5)]?![]:!![];},Window_MenuCommand['prototype'][_0x1ea0b5(0x2e6)]=function(){const _0x461395=_0x1ea0b5;return $gameSystem[_0x461395(0x23b)]();},Window_MenuCommand[_0x1ea0b5(0x369)][_0x1ea0b5(0x1c5)]=function(){const _0x40ed61=_0x1ea0b5;return $gameSystem[_0x40ed61(0x342)]();},Window_TitleCommand[_0x1ea0b5(0x25c)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x387)][_0x1ea0b5(0x319)],VisuMZ['CGGallery'][_0x1ea0b5(0x1ff)]=Window_TitleCommand['prototype'][_0x1ea0b5(0x349)],Window_TitleCommand[_0x1ea0b5(0x369)]['makeCommandList']=function(){const _0x5ac6e6=_0x1ea0b5;VisuMZ[_0x5ac6e6(0x2a5)][_0x5ac6e6(0x1ff)][_0x5ac6e6(0x383)](this),this[_0x5ac6e6(0x365)]();},Window_TitleCommand[_0x1ea0b5(0x369)][_0x1ea0b5(0x365)]=function(){const _0x56513a=_0x1ea0b5;if(!Window_TitleCommand['CG_GALLERY_ADD_COMMAND'])return;if(this[_0x56513a(0x321)](_0x56513a(0x2fe))>=0x0)return;const _0x1ffc08=TextManager['cgGalleryMenuCommand'],_0x56d2ad=$gameSystem['hasCgUnlockedImage']();this[_0x56513a(0x201)](_0x1ffc08,_0x56513a(0x2fe),_0x56d2ad);const _0x123758=this['findSymbol']('options');if(_0x123758>0x0){const _0x4acff0=this[_0x56513a(0x24f)][_0x56513a(0x24c)]();this[_0x56513a(0x24f)][_0x56513a(0x1dd)](_0x123758,0x0,_0x4acff0);}};function _0xf3f1(_0x391a0c,_0x3ce4cb){const _0x1d5f20=_0x1d5f();return _0xf3f1=function(_0xf3f13c,_0x580cc6){_0xf3f13c=_0xf3f13c-0x1b9;let _0x2e3d12=_0x1d5f20[_0xf3f13c];return _0x2e3d12;},_0xf3f1(_0x391a0c,_0x3ce4cb);}function Window_CG_Category(){const _0x5f5736=_0x1ea0b5;this[_0x5f5736(0x306)](...arguments);}Window_CG_Category[_0x1ea0b5(0x369)]=Object['create'](Window_HorzCommand[_0x1ea0b5(0x369)]),Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x39f)]=Window_CG_Category,Window_CG_Category[_0x1ea0b5(0x28b)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)]['Categories'],Window_CG_Category[_0x1ea0b5(0x382)]=VisuMZ[_0x1ea0b5(0x2a5)]['Settings']['Window'][_0x1ea0b5(0x267)],Window_CG_Category[_0x1ea0b5(0x249)]=VisuMZ['CGGallery'][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x2c3)],Window_CG_Category[_0x1ea0b5(0x1f1)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x286)],Window_CG_Category[_0x1ea0b5(0x31e)]=VisuMZ['CGGallery'][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x223)],Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x306)]=function(_0x5a6ea0){const _0x15839c=_0x1ea0b5;Window_HorzCommand[_0x15839c(0x369)]['initialize']['call'](this,_0x5a6ea0),this[_0x15839c(0x21c)](_0x5a6ea0);},Window_CG_Category['prototype']['itemHeight']=function(){const _0x534412=_0x1ea0b5;return this[_0x534412(0x1f0)]();},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x21c)]=function(_0x347a8a){const _0xd50705=_0x1ea0b5,_0x4d7bb7=new Rectangle(0x0,0x0,_0x347a8a[_0xd50705(0x1e4)],_0x347a8a[_0xd50705(0x395)]);this[_0xd50705(0x1e3)]=new Window_Base(_0x4d7bb7),this['_commandNameWindow']['opacity']=0x0,this[_0xd50705(0x236)](this['_commandNameWindow']),this[_0xd50705(0x394)]();},Window_CG_Category['prototype'][_0x1ea0b5(0x277)]=function(){const _0x91b156=_0x1ea0b5;Window_HorzCommand[_0x91b156(0x369)][_0x91b156(0x277)][_0x91b156(0x383)](this);if(this[_0x91b156(0x1e3)])this['updateCommandNameWindow']();},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x394)]=function(){const _0x43602a=_0x1ea0b5,_0x470fbb=this[_0x43602a(0x1e3)];_0x470fbb[_0x43602a(0x202)]['clear']();const _0x193f80=this['commandStyleCheck'](this[_0x43602a(0x390)]());if(_0x193f80===_0x43602a(0x2f3)){if('rpOuO'===_0x43602a(0x1f3)){if(!_0x585b9b[_0x43602a(0x222)])return;_0x54ba98[_0x43602a(0x369)][_0x43602a(0x2ab)][_0x43602a(0x383)](this,_0x32ed45);}else{const _0x585b95=this[_0x43602a(0x32d)](this[_0x43602a(0x390)]());let _0xcc59cd=this[_0x43602a(0x335)](this[_0x43602a(0x390)]());_0xcc59cd=_0xcc59cd['replace'](/\\I\[(\d+)\]/gi,''),_0x470fbb[_0x43602a(0x243)](),this[_0x43602a(0x2ea)](_0xcc59cd,_0x585b95),this['commandNameWindowDrawText'](_0xcc59cd,_0x585b95),this[_0x43602a(0x297)](_0xcc59cd,_0x585b95);}}},Window_CG_Category['prototype']['commandNameWindowDrawBackground']=function(_0x2f0b41,_0x55f945){},Window_CG_Category['prototype']['commandNameWindowDrawText']=function(_0x4dd374,_0x5eb75c){const _0x228248=_0x1ea0b5,_0x39b3b9=this[_0x228248(0x1e3)];_0x39b3b9[_0x228248(0x1d1)](_0x4dd374,0x0,_0x5eb75c['y'],_0x39b3b9[_0x228248(0x1e0)],_0x228248(0x1d8));},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x297)]=function(_0x282fff,_0x57edfd){const _0x4db370=_0x1ea0b5,_0x533e7c=this['_commandNameWindow'],_0x47eabb=$gameSystem[_0x4db370(0x1ea)](),_0x27fe1c=_0x57edfd['x']+Math[_0x4db370(0x31b)](_0x57edfd[_0x4db370(0x1e4)]/0x2)+_0x47eabb;_0x533e7c['x']=_0x533e7c[_0x4db370(0x1e4)]/-0x2+_0x27fe1c,_0x533e7c['y']=Math[_0x4db370(0x31b)](_0x57edfd[_0x4db370(0x395)]/0x2);},Window_CG_Category['prototype'][_0x1ea0b5(0x302)]=function(){const _0x10da59=_0x1ea0b5;let _0xd38a11=Window_CG_Category['COMMAND_LIST'][_0x10da59(0x361)];if(Window_CG_Category[_0x10da59(0x1f1)])_0xd38a11+=0x1;if(VisuMZ[_0x10da59(0x2a5)][_0x10da59(0x214)]())_0xd38a11+=0x1;return _0xd38a11;},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x349)]=function(){const _0x2f49c3=_0x1ea0b5;this[_0x2f49c3(0x230)](),this[_0x2f49c3(0x258)](),this[_0x2f49c3(0x23e)]();},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x230)]=function(){const _0x2f2e1c=_0x1ea0b5;if(!Window_CG_Category['ADD_ALL_COMMAND'])return;const _0x3d3e48='category',_0x47998c=ImageManager[_0x2f2e1c(0x1f5)][_0x2f2e1c(0x399)][_0x2f2e1c(0x391)];let _0x29258e=TextManager['CG_GALLERY'][_0x2f2e1c(0x396)][_0x2f2e1c(0x391)];if(_0x47998c>0x0&&this['commandStyle']()!==_0x2f2e1c(0x37c)){if(_0x2f2e1c(0x3a7)!==_0x2f2e1c(0x27a))_0x29258e='\x5cI[%1]%2'[_0x2f2e1c(0x248)](_0x47998c,_0x29258e);else{if(!this[_0x2f2e1c(0x269)])return;const _0x1655b8=this[_0x2f2e1c(0x3ab)]()[_0x2f2e1c(0x36b)]['toLowerCase']()[_0x2f2e1c(0x1cb)]();this[_0x2f2e1c(0x269)][_0x2f2e1c(0x3a4)](_0x1655b8);}}const _0xeacfa5={'Key':_0x2f2e1c(0x391),'Description':TextManager['CG_GALLERY']['helpDesc'][_0x2f2e1c(0x391)]};this['addCommand'](_0x29258e,_0x3d3e48,!![],_0xeacfa5);},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x258)]=function(){const _0x1105fd=_0x1ea0b5;for(const _0x54bdef of Window_CG_Category[_0x1105fd(0x28b)]){const _0x517c95='category',_0x33e637=_0x54bdef[_0x1105fd(0x325)];let _0x1df973=_0x54bdef[_0x1105fd(0x3a8)];if(['',_0x1105fd(0x221)][_0x1105fd(0x1ba)](_0x1df973))continue;_0x33e637>0x0&&this[_0x1105fd(0x329)]()!==_0x1105fd(0x37c)&&(_0x1df973='\x5cI[%1]%2'[_0x1105fd(0x248)](_0x33e637,_0x1df973)),this[_0x1105fd(0x201)](_0x1df973,_0x517c95,!![],_0x54bdef);}},Window_CG_Category['prototype'][_0x1ea0b5(0x23e)]=function(){const _0x3674cd=_0x1ea0b5;if(!Window_CG_Category[_0x3674cd(0x31e)])return;if(!VisuMZ[_0x3674cd(0x2a5)][_0x3674cd(0x214)]())return;const _0x410017=_0x3674cd(0x396),_0x15d923=ImageManager[_0x3674cd(0x1f5)][_0x3674cd(0x399)][_0x3674cd(0x384)];let _0x68f4ae=TextManager['CG_GALLERY'][_0x3674cd(0x396)][_0x3674cd(0x384)];_0x15d923>0x0&&this[_0x3674cd(0x329)]()!==_0x3674cd(0x37c)&&(_0x68f4ae=_0x3674cd(0x354)[_0x3674cd(0x248)](_0x15d923,_0x68f4ae));const _0x2c1e58={'Key':_0x3674cd(0x391),'Description':TextManager[_0x3674cd(0x1f5)][_0x3674cd(0x215)][_0x3674cd(0x384)]};this[_0x3674cd(0x201)](_0x68f4ae,_0x410017,!![],_0x2c1e58);},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x252)]=function(){const _0x5626d4=_0x1ea0b5;this[_0x5626d4(0x273)]['setText'](this[_0x5626d4(0x3ab)]()?this[_0x5626d4(0x3ab)]()[_0x5626d4(0x25a)]:''),this[_0x5626d4(0x377)]();},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x2b3)]=function(){const _0x3ba7a3=_0x1ea0b5;return Window_CG_Category[_0x3ba7a3(0x249)];},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x239)]=function(_0x472b7d){const _0x23295b=_0x1ea0b5,_0x523d2c=this['commandStyleCheck'](_0x472b7d);if(_0x523d2c===_0x23295b(0x1c1))this['drawItemStyleIconText'](_0x472b7d);else _0x523d2c==='icon'?_0x23295b(0x30e)===_0x23295b(0x287)?this[_0x23295b(0x292)]():this[_0x23295b(0x213)](_0x472b7d):Window_HorzCommand['prototype']['drawItem'][_0x23295b(0x383)](this,_0x472b7d);},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x329)]=function(){const _0x30c70c=_0x1ea0b5;return Window_CG_Category[_0x30c70c(0x382)];},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x2b9)]=function(_0x45a336){const _0x1d4e23=_0x1ea0b5;if(_0x45a336<0x0)return'text';const _0x30c763=this[_0x1d4e23(0x329)]();if(_0x30c763!==_0x1d4e23(0x2e7))return _0x30c763;else{if(this['maxItems']()>0x0){if(_0x1d4e23(0x38c)!==_0x1d4e23(0x32e)){const _0x2d4f31=this[_0x1d4e23(0x335)](_0x45a336);if(_0x2d4f31['match'](/\\I\[(\d+)\]/i)){if('tdUDv'!==_0x1d4e23(0x2e3))_0xedd154=_0x3fb6da[_0x1d4e23(0x294)](_0x45f3a5,_0x2a0b67);else{const _0x3e1c10=this[_0x1d4e23(0x32d)](_0x45a336),_0xdbbcd2=this[_0x1d4e23(0x290)](_0x2d4f31)['width'];return _0xdbbcd2<=_0x3e1c10['width']?_0x1d4e23(0x245)==='qcXNs'?_0x3e1eca[_0x1d4e23(0x345)]:'iconText':'icon';}}}else _0x4c605d['CGGallery'][_0x1d4e23(0x35e)][_0x1d4e23(0x383)](this,_0x182da4,_0x5d02cf,_0x44b23c,_0x1893d5,_0x3445df,_0x332fa2,_0x44c7c3,_0x24068b),_0x59ee37[_0x1d4e23(0x1f5)]['autoUnlock']&&_0x4d9fad[_0x1d4e23(0x22c)](_0x5d7bc8);}}return _0x1d4e23(0x37c);},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x1ee)]=function(_0x145d5f){const _0x2e18f0=_0x1ea0b5,_0x417de4=this[_0x2e18f0(0x32d)](_0x145d5f),_0x24ba92=this[_0x2e18f0(0x335)](_0x145d5f),_0x2874aa=this[_0x2e18f0(0x290)](_0x24ba92)[_0x2e18f0(0x1e4)];this[_0x2e18f0(0x210)](this[_0x2e18f0(0x240)](_0x145d5f));const _0x2ecd2f=this['itemTextAlign']();if(_0x2ecd2f===_0x2e18f0(0x29d))_0x2e18f0(0x388)!==_0x2e18f0(0x283)?this[_0x2e18f0(0x340)](_0x24ba92,_0x417de4['x']+_0x417de4[_0x2e18f0(0x1e4)]-_0x2874aa,_0x417de4['y'],_0x2874aa):(this[_0x2e18f0(0x2d0)][_0x2e18f0(0x1e1)](),this[_0x2e18f0(0x269)][_0x2e18f0(0x218)](),this[_0x2e18f0(0x269)]['reselect'](),this['_galleryWindow'][_0x2e18f0(0x390)]()<0x0&&this['_galleryWindow'][_0x2e18f0(0x1fe)](0x0));else{if(_0x2ecd2f===_0x2e18f0(0x1d8)){const _0x4a42fd=_0x417de4['x']+Math[_0x2e18f0(0x31b)]((_0x417de4[_0x2e18f0(0x1e4)]-_0x2874aa)/0x2);this[_0x2e18f0(0x340)](_0x24ba92,_0x4a42fd,_0x417de4['y'],_0x2874aa);}else this['drawTextEx'](_0x24ba92,_0x417de4['x'],_0x417de4['y'],_0x2874aa);}},Window_CG_Category[_0x1ea0b5(0x369)]['drawItemStyleIcon']=function(_0x1dddc7){const _0x1f6d7c=_0x1ea0b5;this[_0x1f6d7c(0x335)](_0x1dddc7)[_0x1f6d7c(0x206)](/\\I\[(\d+)\]/i);const _0x596a7e=Number(RegExp['$1'])||0x0,_0x5b54a6=this[_0x1f6d7c(0x32d)](_0x1dddc7),_0x462ee4=_0x5b54a6['x']+Math[_0x1f6d7c(0x31b)]((_0x5b54a6[_0x1f6d7c(0x1e4)]-ImageManager['iconWidth'])/0x2),_0x9f029f=_0x5b54a6['y']+(_0x5b54a6[_0x1f6d7c(0x395)]-ImageManager[_0x1f6d7c(0x37d)])/0x2;this['drawIcon'](_0x596a7e,_0x462ee4,_0x9f029f);},Window_CG_Category[_0x1ea0b5(0x369)][_0x1ea0b5(0x1de)]=function(_0x533e98){const _0x4ec32d=_0x1ea0b5;this[_0x4ec32d(0x269)]=_0x533e98,this[_0x4ec32d(0x377)]();},Window_CG_Category['prototype'][_0x1ea0b5(0x377)]=function(){const _0x5860ca=_0x1ea0b5;if(!this[_0x5860ca(0x269)])return;const _0x5731a5=this[_0x5860ca(0x3ab)]()[_0x5860ca(0x36b)][_0x5860ca(0x2c5)]()[_0x5860ca(0x1cb)]();this[_0x5860ca(0x269)]['setCategory'](_0x5731a5);};function Window_CG_Gallery(){const _0x4c6362=_0x1ea0b5;this[_0x4c6362(0x306)](...arguments);}Window_CG_Gallery[_0x1ea0b5(0x369)]=Object[_0x1ea0b5(0x2eb)](Window_Command[_0x1ea0b5(0x369)]),Window_CG_Gallery['prototype'][_0x1ea0b5(0x39f)]=Window_CG_Gallery,Window_CG_Gallery['MAXCOL']=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x33a)],Window_CG_Gallery[_0x1ea0b5(0x29c)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x386)],Window_CG_Gallery[_0x1ea0b5(0x2b8)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x2dd)],Window_CG_Gallery[_0x1ea0b5(0x359)]=VisuMZ['CGGallery'][_0x1ea0b5(0x375)]['Window']['GalleryWindow_SpacingRows'],Window_CG_Gallery[_0x1ea0b5(0x38e)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x363)],Window_CG_Gallery[_0x1ea0b5(0x2c9)]=VisuMZ['CGGallery']['Settings'][_0x1ea0b5(0x23f)][_0x1ea0b5(0x344)],Window_CG_Gallery['STAGGER_LEFT']=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)]['GalleryWindow_StaggerToLeft'],Window_CG_Gallery[_0x1ea0b5(0x222)]=VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)]['GalleryWindow_ListingBack'],Window_CG_Gallery[_0x1ea0b5(0x2da)]={'show':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x23f)]['GalleryWindow_Text_VariationsShow'],'hideForSingles':!VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x3b1)],'xAlign':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)]['GalleryWindow_Text_VariationsAlignX'],'yAlign':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x2b7)],'variantComplete':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x22a)],'textFmt':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x392)]},Window_CG_Gallery[_0x1ea0b5(0x364)]={'show':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)]['GalleryWindow_Text_CompletionShow'],'text':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x397)],'percentFmt':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)]['Vocab'][_0x1ea0b5(0x1cd)],'decimals':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x204)],'fontFace':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x2fd)],'fontSize1':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x23f)]['GalleryWindow_Text_CompletionFontSize1'],'fontSize2':VisuMZ['CGGallery'][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x36d)],'offset':{'x':VisuMZ['CGGallery'][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x322)],'y':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)]['GalleryWindow_Text_CompletionOffsetY']},'angle':VisuMZ['CGGallery'][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)]['GalleryWindow_Text_CompletionAngle']},Window_CG_Gallery[_0x1ea0b5(0x1d4)]={'show':VisuMZ['CGGallery']['Settings'][_0x1ea0b5(0x23f)][_0x1ea0b5(0x1e5)],'text':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x2a3)]['GalleryWindow_Text_ProgressVocab'],'percentFmt':VisuMZ['CGGallery'][_0x1ea0b5(0x375)][_0x1ea0b5(0x2a3)][_0x1ea0b5(0x2d6)],'decimals':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)]['GalleryWindow_Text_ProgressDecimals'],'fontFace':VisuMZ['CGGallery']['Settings']['Window'][_0x1ea0b5(0x2a4)],'fontSize1':VisuMZ[_0x1ea0b5(0x2a5)]['Settings'][_0x1ea0b5(0x23f)][_0x1ea0b5(0x2c4)],'fontSize2':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)]['Window'][_0x1ea0b5(0x2e8)],'offset':{'x':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)][_0x1ea0b5(0x23f)][_0x1ea0b5(0x2e4)],'y':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)]['Window']['GalleryWindow_Text_ProgressOffsetY']},'angle':VisuMZ[_0x1ea0b5(0x2a5)][_0x1ea0b5(0x375)]['Window'][_0x1ea0b5(0x1e8)]},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x306)]=function(_0x439516){const _0x2d9750=_0x1ea0b5;this[_0x2d9750(0x2e5)]='',Window_Command['prototype'][_0x2d9750(0x306)][_0x2d9750(0x383)](this,_0x439516),this['createCompletionSprite'](),this[_0x2d9750(0x1bb)]();},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x3a5)]=function(){const _0x5942cb=_0x1ea0b5;if(this[_0x5942cb(0x2aa)]!==undefined)return this[_0x5942cb(0x2aa)];const _0x4f723a=(this[_0x5942cb(0x1e0)]-Window_CG_Gallery[_0x5942cb(0x2c9)])/this['maxCols']();return this[_0x5942cb(0x2aa)]=Math[_0x5942cb(0x31b)](_0x4f723a),this['_itemWidth'];},Window_CG_Gallery[_0x1ea0b5(0x369)]['itemHeight']=function(){const _0x42eddd=_0x1ea0b5;if(this[_0x42eddd(0x356)]!==undefined)return this[_0x42eddd(0x356)];const _0x4491ec=this[_0x42eddd(0x1df)]/Window_CG_Gallery[_0x42eddd(0x29c)];return this[_0x42eddd(0x356)]=Math[_0x42eddd(0x328)](_0x4491ec),this['_itemHeight'];},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x24d)]=function(){const _0x59d301=_0x1ea0b5;return Window_CG_Gallery[_0x59d301(0x2b8)];},Window_CG_Gallery[_0x1ea0b5(0x369)]['rowSpacing']=function(){const _0x1e2933=_0x1ea0b5;return Window_CG_Gallery[_0x1e2933(0x359)];},Window_CG_Gallery['prototype'][_0x1ea0b5(0x302)]=function(){const _0x44435a=_0x1ea0b5;return Window_CG_Gallery[_0x44435a(0x345)];},Window_CG_Gallery[_0x1ea0b5(0x369)]['itemRect']=function(_0x551d30){const _0x3f3868=_0x1ea0b5,_0x5a6977=this['maxCols'](),_0x48005b=Window_CG_Gallery[_0x3f3868(0x29c)]-0x1,_0x4b41e3=this[_0x3f3868(0x3a5)](),_0x437c5c=this[_0x3f3868(0x389)](),_0x425716=this[_0x3f3868(0x24d)](),_0x4aad74=this['rowSpacing'](),_0x4d3129=_0x551d30%_0x5a6977,_0x37b804=Math[_0x3f3868(0x31b)](_0x551d30/_0x5a6977),_0x109f56=this[_0x3f3868(0x2a9)](),_0x3b70fb=Window_CG_Gallery[_0x3f3868(0x2c9)],_0x4e4009=_0x37b804-_0x109f56;let _0x511994=0x0;Window_CG_Gallery[_0x3f3868(0x376)]?_0x3f3868(0x251)===_0x3f3868(0x251)?_0x511994=Math['floor']((_0x48005b-_0x4e4009)/_0x48005b*_0x3b70fb):this[_0x3f3868(0x254)]<=0x0?(_0x1b08d3[_0x3f3868(0x2dc)](),this['exitViewMode']()):this['processVariationChange'](![]):_0x511994=Math[_0x3f3868(0x31b)](_0x4e4009/_0x48005b*_0x3b70fb);const _0x22c565=_0x4d3129*_0x4b41e3+_0x425716/0x2-this['scrollBaseX']()+_0x511994,_0x3b282b=_0x37b804*_0x437c5c+_0x4aad74/0x2-this['scrollBaseY'](),_0x552ef7=_0x4b41e3-_0x425716,_0x23a06d=_0x437c5c-_0x4aad74;return new Rectangle(_0x22c565,_0x3b282b,_0x552ef7,_0x23a06d);},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2f1)]=function(_0x55d60f,_0x5aea8e){const _0x49e239=_0x1ea0b5;if(Window_CG_Gallery[_0x49e239(0x2c9)]<=0x0){if(_0x49e239(0x242)!==_0x49e239(0x242))this[_0x49e239(0x22e)]();else return Window_Command[_0x49e239(0x369)]['smoothScrollTo'][_0x49e239(0x383)](this,_0x55d60f,_0x5aea8e);}this[_0x49e239(0x35c)]=_0x55d60f[_0x49e239(0x38f)](0x0,this[_0x49e239(0x1d7)]()),this[_0x49e239(0x2bd)]=_0x5aea8e[_0x49e239(0x38f)](0x0,this[_0x49e239(0x30d)]()),this['_scrollDuration']=0x1,this[_0x49e239(0x336)](),this[_0x49e239(0x385)]();},Window_CG_Gallery['prototype'][_0x1ea0b5(0x20d)]=function(){const _0x3f2efe=_0x1ea0b5;if(this[_0x3f2efe(0x29e)]()&&this[_0x3f2efe(0x308)]){if(_0x3f2efe(0x270)!=='nmUjT'){const _0x5058cc=this[_0x3f2efe(0x207)](),_0x5b700f=new _0x59ee61(_0x5058cc);_0x5b700f[_0x3f2efe(0x1e1)](),_0x5b700f[_0x3f2efe(0x2d5)](),this['_categoryWindow'][_0x3f2efe(0x1de)](_0x5b700f),_0x5b700f['setHelpWindow'](this[_0x3f2efe(0x273)]),_0x5b700f[_0x3f2efe(0x28c)]('listing',this['prepareViewMode'][_0x3f2efe(0x334)](this)),_0x5b700f[_0x3f2efe(0x28c)]('cancel',this['onCategoryCancel'][_0x3f2efe(0x334)](this)),this[_0x3f2efe(0x1dc)](_0x5b700f),this[_0x3f2efe(0x269)]=_0x5b700f,_0x5b700f['setBackgroundType'](_0x2fd835['CG_WINDOW_BGTYPE']);}else{const _0x59b641=0x14;TouchInput[_0x3f2efe(0x20b)]>=_0x59b641&&(this[_0x3f2efe(0x2d3)](![]),this['_wheelCooldown']=0x8),TouchInput['wheelY']<=-_0x59b641&&(this['cursorUp'](![]),this[_0x3f2efe(0x2a8)]=0x8);}}},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x1e9)]=function(_0xaeca5){const _0x251856=_0x1ea0b5;if(this[_0x251856(0x2a8)]){if('IOkvw'!==_0x251856(0x200)){const _0x463035=this[_0x251856(0x32d)](_0x2a93f4),_0x16129e=this[_0x251856(0x335)](_0x310b2e),_0x2810c9=this['textSizeEx'](_0x16129e)[_0x251856(0x1e4)];this[_0x251856(0x210)](this[_0x251856(0x240)](_0x3edccb));const _0x3c455e=this['itemTextAlign']();if(_0x3c455e===_0x251856(0x29d))this[_0x251856(0x340)](_0x16129e,_0x463035['x']+_0x463035[_0x251856(0x1e4)]-_0x2810c9,_0x463035['y'],_0x2810c9);else{if(_0x3c455e==='center'){const _0x15927c=_0x463035['x']+_0x454ada['floor']((_0x463035[_0x251856(0x1e4)]-_0x2810c9)/0x2);this['drawTextEx'](_0x16129e,_0x15927c,_0x463035['y'],_0x2810c9);}else this[_0x251856(0x340)](_0x16129e,_0x463035['x'],_0x463035['y'],_0x2810c9);}}else{this[_0x251856(0x2a8)]--;return;}}Window_Command[_0x251856(0x369)][_0x251856(0x1e9)][_0x251856(0x383)](this,_0xaeca5);},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x351)]=function(){const _0x10507d=_0x1ea0b5;SoundManager[_0x10507d(0x2fa)]();},Window_CG_Gallery[_0x1ea0b5(0x369)]['setCategory']=function(_0x5aae90){const _0x393272=_0x1ea0b5;_0x5aae90=_0x5aae90[_0x393272(0x2c5)]()[_0x393272(0x1cb)]();if(this[_0x393272(0x2e5)]===_0x5aae90)return;this[_0x393272(0x2e5)]=_0x5aae90,this[_0x393272(0x3aa)](),this[_0x393272(0x3a9)](0x0),this[_0x393272(0x2d5)](),this[_0x393272(0x36c)](),this[_0x393272(0x20c)]();},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x349)]=function(){const _0x31869c=_0x1ea0b5,_0x14a63b=VisuMZ[_0x31869c(0x2a5)][_0x31869c(0x375)]['Listing'];for(const _0xd7fd01 of _0x14a63b){if(!this[_0x31869c(0x1ba)](_0xd7fd01))continue;const _0x56559d=$gameSystem[_0x31869c(0x2f2)](_0xd7fd01[_0x31869c(0x256)]);this[_0x31869c(0x201)]('','listing',_0x56559d,_0xd7fd01);}},Window_CG_Gallery['prototype'][_0x1ea0b5(0x1ba)]=function(_0x294893){const _0x264e98=_0x1ea0b5;if(!_0x294893)return![];if(_0x294893[_0x264e98(0x256)][_0x264e98(0x2c5)]()['trim']()===_0x264e98(0x1b9))return![];if(_0x294893[_0x264e98(0x256)][_0x264e98(0x1cb)]()==='')return![];if(this[_0x264e98(0x2e5)]===_0x264e98(0x391))return!![];const _0x3d9820=_0x294893['Category']['toLowerCase']()['trim']();if(this[_0x264e98(0x2e5)]===_0x264e98(0x384)){const _0x28c1cd=VisuMZ[_0x264e98(0x2a5)][_0x264e98(0x1ed)]();return!_0x28c1cd[_0x264e98(0x1ba)](_0x3d9820);}else return this[_0x264e98(0x2e5)]===_0x3d9820;},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x252)]=function(){const _0x3cb587=_0x1ea0b5;Window_Command[_0x3cb587(0x369)]['updateHelp']['call'](this);const _0x1dc3cd=this[_0x3cb587(0x3ab)]();if(_0x1dc3cd){if($gameSystem[_0x3cb587(0x2f2)](_0x1dc3cd[_0x3cb587(0x256)])){if(_0x3cb587(0x315)===_0x3cb587(0x315))this[_0x3cb587(0x273)]['setText'](_0x1dc3cd['Description']||'');else{_0x5d3210=_0x1e7001||_0x3cb587(0x391);const _0x3770ea=this[_0x3cb587(0x346)](_0x4ffd61);let _0x1ebe54=this[_0x3cb587(0x320)](_0x414b09);return _0x1ebe54/_0x3770ea;}}else this[_0x3cb587(0x273)][_0x3cb587(0x27b)](TextManager[_0x3cb587(0x1f5)]['helpDesc'][_0x3cb587(0x326)]);}},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x2ab)]=function(_0x1ab6cc){const _0x39f0d8=_0x1ea0b5;if(!Window_CG_Gallery['DRAW_ITEM_BACKGROUND'])return;Window_Command['prototype'][_0x39f0d8(0x2ab)][_0x39f0d8(0x383)](this,_0x1ab6cc);},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x239)]=function(_0x5775da){const _0x27ccae=_0x1ea0b5;if(!this[_0x27ccae(0x24f)])return;if(!this[_0x27ccae(0x24f)][_0x5775da])return;const _0x1784fb=this[_0x27ccae(0x24f)][_0x5775da][_0x27ccae(0x34f)];if(!_0x1784fb)return;const _0x32b5d2=this[_0x27ccae(0x26d)](_0x5775da),_0x369b01=_0x1784fb[_0x27ccae(0x256)];if($gameSystem[_0x27ccae(0x2f2)](_0x369b01)){const _0xdfc1cf=ImageManager['loadPicture'](_0x369b01);_0xdfc1cf[_0x27ccae(0x35b)](this['drawPicture']['bind'](this,_0x1784fb,_0xdfc1cf,_0x5775da,_0x32b5d2));}else{const _0x267fe2=ImageManager[_0x27ccae(0x31f)]();_0x267fe2[_0x27ccae(0x35b)](this[_0x27ccae(0x36e)][_0x27ccae(0x334)](this,_0x1784fb,_0x267fe2,_0x5775da,_0x32b5d2));}},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x36e)]=function(_0x423646,_0x481187,_0x57f920,_0x284fc0){const _0x303546=_0x1ea0b5,_0xd99c5c=this['itemRect'](_0x57f920);if(JSON[_0x303546(0x21b)](_0xd99c5c)!==JSON[_0x303546(0x21b)](_0x284fc0))return;_0xd99c5c['width']-=Window_CG_Gallery['IMG_BUFFER']*0x2,_0xd99c5c[_0x303546(0x395)]-=Window_CG_Gallery['IMG_BUFFER']*0x2,_0xd99c5c['x']+=Window_CG_Gallery['IMG_BUFFER'],_0xd99c5c['y']+=Window_CG_Gallery[_0x303546(0x38e)];let _0x496735=_0xd99c5c['x'],_0x18c002=_0xd99c5c['y'];const _0x1d33e1=_0xd99c5c[_0x303546(0x1e4)]/_0x481187['width'],_0x3534b3=_0xd99c5c[_0x303546(0x395)]/_0x481187['height'],_0x54e37b=Math[_0x303546(0x2c1)](_0x1d33e1,_0x3534b3,0x1),_0x2bd984=Math[_0x303546(0x25b)](_0x481187[_0x303546(0x1e4)]*_0x54e37b),_0x31ff5f=Math['round'](_0x481187[_0x303546(0x395)]*_0x54e37b);_0x496735+=Math[_0x303546(0x25b)]((_0xd99c5c[_0x303546(0x1e4)]-_0x2bd984)/0x2),_0x18c002+=Math[_0x303546(0x25b)]((_0xd99c5c[_0x303546(0x395)]-_0x31ff5f)/0x2);const _0x20bb15=_0x481187[_0x303546(0x1e4)],_0x3aa3c5=_0x481187['height'];this[_0x303546(0x202)][_0x303546(0x231)][_0x303546(0x3ac)]=!![],this[_0x303546(0x202)][_0x303546(0x2e9)](_0x481187,0x0,0x0,_0x20bb15,_0x3aa3c5,_0x496735,_0x18c002,_0x2bd984,_0x31ff5f),this[_0x303546(0x202)]['_context'][_0x303546(0x3ac)]=!![],this[_0x303546(0x284)](_0x423646,_0x57f920);},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x284)]=function(_0x394309,_0x1d3e4d){const _0x1628a2=_0x1ea0b5;if(!Window_CG_Gallery[_0x1628a2(0x2da)][_0x1628a2(0x233)])return;if(!$gameSystem[_0x1628a2(0x2f2)](_0x394309[_0x1628a2(0x256)],![]))return;const _0x1f0dfc=_0x394309['Variations'][_0x1628a2(0x361)]+0x1;if(Window_CG_Gallery[_0x1628a2(0x2da)]['hideForSingles']&&_0x1f0dfc===0x1)return;let _0x92ab72=0x1;for(let _0x4e5e9f of _0x394309['Variations']){if($gameSystem['isCgGalleryUnlocked'](_0x4e5e9f,!![]))_0x92ab72+=0x1;}let _0x17b1db='';if(_0x1f0dfc===_0x92ab72&&Window_CG_Gallery[_0x1628a2(0x2da)][_0x1628a2(0x235)]!==''){if('DjrWR'!==_0x1628a2(0x22d)){if(_0x3378a7['isCgGalleryUnlocked'](_0x1986ff,!![]))_0xf45757+=0x1;}else _0x17b1db=Window_CG_Gallery['DRAW_VARIATION'][_0x1628a2(0x235)];}else{const _0x5c13ed=Window_CG_Gallery['DRAW_VARIATION'][_0x1628a2(0x1c0)],_0x5c83f8=Window_CG_Gallery['DRAW_VARIATION'][_0x1628a2(0x253)],_0x2cb1a6=Math[_0x1628a2(0x25b)](_0x92ab72/_0x1f0dfc*0x64);_0x17b1db=_0x5c13ed[_0x1628a2(0x248)](_0x2cb1a6,_0x92ab72,_0x1f0dfc);}const _0x590d36=this[_0x1628a2(0x1bc)](_0x1d3e4d);let _0x8ecca=_0x590d36['x'],_0x53ed3e=_0x590d36['y'];const _0x340e63=this[_0x1628a2(0x290)](_0x17b1db)[_0x1628a2(0x1e4)],_0x2e6f62=this[_0x1628a2(0x290)](_0x17b1db)[_0x1628a2(0x395)],_0x26b2c4=Window_CG_Gallery[_0x1628a2(0x2da)]['xAlign'][_0x1628a2(0x2c5)]()[_0x1628a2(0x1cb)]();switch(_0x26b2c4){case _0x1628a2(0x1d8):_0x8ecca+=Math[_0x1628a2(0x31b)](_0x590d36[_0x1628a2(0x1e4)]-_0x340e63)/0x2;break;case'right':_0x8ecca+=_0x590d36[_0x1628a2(0x1e4)]-_0x340e63;break;}switch(Window_CG_Gallery[_0x1628a2(0x2da)][_0x1628a2(0x2b0)][_0x1628a2(0x2c5)]()[_0x1628a2(0x1cb)]()){case _0x1628a2(0x2a2):_0x53ed3e+=Math[_0x1628a2(0x31b)](_0x590d36[_0x1628a2(0x395)]-_0x2e6f62)/0x2;break;case _0x1628a2(0x36a):_0x53ed3e+=_0x590d36[_0x1628a2(0x395)]-_0x2e6f62;break;}this[_0x1628a2(0x340)](_0x17b1db,_0x8ecca,_0x53ed3e);},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x28e)]=function(){const _0x29bfad=_0x1ea0b5;if(!Window_CG_Gallery[_0x29bfad(0x364)][_0x29bfad(0x233)])return;const _0x2ec756=new Sprite();this[_0x29bfad(0x236)](_0x2ec756);const _0x33ef69=Math[_0x29bfad(0x294)](Window_CG_Gallery[_0x29bfad(0x2c9)],0x64);_0x2ec756[_0x29bfad(0x260)]=new Bitmap(_0x33ef69,this['itemHeight']()),_0x2ec756[_0x29bfad(0x2f0)]['x']=0.5,_0x2ec756[_0x29bfad(0x2f0)]['y']=0.5,this[_0x29bfad(0x291)]=_0x2ec756,this[_0x29bfad(0x36c)](),Window_CG_Gallery[_0x29bfad(0x376)]?_0x2ec756['x']=this['padding']+Math[_0x29bfad(0x31b)](Window_CG_Gallery[_0x29bfad(0x2c9)]/0x2):_0x2ec756['x']=this['width']-(this[_0x29bfad(0x30c)]+Math[_0x29bfad(0x31b)](Window_CG_Gallery[_0x29bfad(0x2c9)]/0x2)),_0x2ec756['y']=this[_0x29bfad(0x30c)]+Math[_0x29bfad(0x31b)](this[_0x29bfad(0x389)]()/0x2),_0x2ec756['x']+=Window_CG_Gallery[_0x29bfad(0x364)][_0x29bfad(0x22f)]['x'],_0x2ec756['y']+=Window_CG_Gallery[_0x29bfad(0x364)][_0x29bfad(0x22f)]['y'],_0x2ec756[_0x29bfad(0x39e)]=-Window_CG_Gallery[_0x29bfad(0x364)][_0x29bfad(0x39e)];},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x36c)]=function(){const _0x2cf3a1=_0x1ea0b5,_0x4bf5=this[_0x2cf3a1(0x291)],_0x1c12c6=_0x4bf5[_0x2cf3a1(0x260)];_0x1c12c6[_0x2cf3a1(0x2f5)]();const _0x616e95=Window_CG_Gallery[_0x2cf3a1(0x364)]['text'];_0x1c12c6[_0x2cf3a1(0x398)]=Window_CG_Gallery[_0x2cf3a1(0x364)][_0x2cf3a1(0x398)],_0x1c12c6['fontSize']=Window_CG_Gallery[_0x2cf3a1(0x364)][_0x2cf3a1(0x37e)];const _0x437961=Math[_0x2cf3a1(0x25b)](_0x1c12c6[_0x2cf3a1(0x395)]/0x2)-(_0x1c12c6[_0x2cf3a1(0x3ae)]+0x4);_0x1c12c6[_0x2cf3a1(0x1d1)](_0x616e95,0x0,_0x437961,_0x1c12c6[_0x2cf3a1(0x1e4)],_0x1c12c6[_0x2cf3a1(0x3ae)]+0x4,_0x2cf3a1(0x1d8));const _0x41ea6e=$gameSystem[_0x2cf3a1(0x2ad)](this['_category']),_0x54f581=Window_CG_Gallery[_0x2cf3a1(0x364)][_0x2cf3a1(0x253)],_0x4140db=(_0x41ea6e*0x64)[_0x2cf3a1(0x21f)](_0x54f581),_0x3e106c=$gameSystem['cgGalleryCurrentCount'](this[_0x2cf3a1(0x2e5)]),_0x146961=$gameSystem[_0x2cf3a1(0x346)](this['_category']),_0x32916d=Window_CG_Gallery['COMPLETION_SPRITE'][_0x2cf3a1(0x314)][_0x2cf3a1(0x248)](_0x4140db,_0x3e106c,_0x146961);_0x1c12c6['fontFace']=Window_CG_Gallery[_0x2cf3a1(0x364)][_0x2cf3a1(0x398)],_0x1c12c6[_0x2cf3a1(0x3ae)]=Window_CG_Gallery[_0x2cf3a1(0x364)][_0x2cf3a1(0x353)];const _0x19674a=Math[_0x2cf3a1(0x25b)](_0x1c12c6[_0x2cf3a1(0x395)]/0x2);_0x1c12c6[_0x2cf3a1(0x1d1)](_0x32916d,0x0,_0x19674a,_0x1c12c6[_0x2cf3a1(0x1e4)],_0x1c12c6[_0x2cf3a1(0x3ae)]+0x4,_0x2cf3a1(0x1d8));},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x1bb)]=function(){const _0x221868=_0x1ea0b5;if(!Window_CG_Gallery[_0x221868(0x1d4)][_0x221868(0x233)])return;const _0x4bf741=new Sprite();this[_0x221868(0x236)](_0x4bf741);const _0x38426c=Math[_0x221868(0x294)](Window_CG_Gallery[_0x221868(0x2c9)],0x64);_0x4bf741['bitmap']=new Bitmap(_0x38426c,this[_0x221868(0x389)]()),_0x4bf741['anchor']['x']=0.5,_0x4bf741['anchor']['y']=0.5,this[_0x221868(0x2d1)]=_0x4bf741,this[_0x221868(0x20c)]();if(Window_CG_Gallery[_0x221868(0x376)]){if(_0x221868(0x1d9)!=='oCUXp')_0x4bf741['x']=this[_0x221868(0x1e4)]-(this[_0x221868(0x30c)]+Math[_0x221868(0x31b)](Window_CG_Gallery[_0x221868(0x2c9)]/0x2));else{if(this[_0x221868(0x3b2)]===_0xdfa734)this[_0x221868(0x27f)]();this[_0x221868(0x3b2)]['enabled']=_0x4c8f42;}}else _0x4bf741['x']=this[_0x221868(0x30c)]+Math['floor'](Window_CG_Gallery[_0x221868(0x2c9)]/0x2);_0x4bf741['y']=this[_0x221868(0x395)]-this['padding']-Math['floor'](this[_0x221868(0x389)]()/0x2),_0x4bf741['x']+=Window_CG_Gallery[_0x221868(0x1d4)][_0x221868(0x22f)]['x'],_0x4bf741['y']+=Window_CG_Gallery[_0x221868(0x1d4)][_0x221868(0x22f)]['y'],_0x4bf741['angle']=-Window_CG_Gallery[_0x221868(0x1d4)][_0x221868(0x39e)];},Window_CG_Gallery[_0x1ea0b5(0x369)][_0x1ea0b5(0x20c)]=function(){const _0x471a0a=_0x1ea0b5,_0x492e03=this[_0x471a0a(0x2d1)],_0x1b54df=_0x492e03[_0x471a0a(0x260)];_0x1b54df[_0x471a0a(0x2f5)]();const _0x2691fd=Window_CG_Gallery['PROGRESS_SPRITE'][_0x471a0a(0x37c)];_0x1b54df[_0x471a0a(0x398)]=Window_CG_Gallery['PROGRESS_SPRITE'][_0x471a0a(0x398)],_0x1b54df[_0x471a0a(0x3ae)]=Window_CG_Gallery[_0x471a0a(0x1d4)][_0x471a0a(0x37e)];const _0x14d81c=Math[_0x471a0a(0x25b)](_0x1b54df['height']/0x2)-(_0x1b54df[_0x471a0a(0x3ae)]+0x4);_0x1b54df[_0x471a0a(0x1d1)](_0x2691fd,0x0,_0x14d81c,_0x1b54df[_0x471a0a(0x1e4)],_0x1b54df[_0x471a0a(0x3ae)]+0x4,_0x471a0a(0x1d8));const _0x5d098a=$gameSystem[_0x471a0a(0x2ad)](this[_0x471a0a(0x2e5)]),_0x4ebb1c=Window_CG_Gallery[_0x471a0a(0x1d4)]['decimals'],_0x2a27b7=(_0x5d098a*0x64)[_0x471a0a(0x21f)](_0x4ebb1c),_0x2c5693=$gameSystem[_0x471a0a(0x320)](this[_0x471a0a(0x2e5)]),_0x3fa0e2=$gameSystem[_0x471a0a(0x346)](this[_0x471a0a(0x2e5)]),_0x1684a2=Window_CG_Gallery[_0x471a0a(0x1d4)]['percentFmt'][_0x471a0a(0x248)](_0x2a27b7,_0x2c5693,_0x3fa0e2);_0x1b54df[_0x471a0a(0x398)]=Window_CG_Gallery['PROGRESS_SPRITE']['fontFace'],_0x1b54df[_0x471a0a(0x3ae)]=Window_CG_Gallery[_0x471a0a(0x1d4)][_0x471a0a(0x353)];const _0x3c8637=Math[_0x471a0a(0x25b)](_0x1b54df[_0x471a0a(0x395)]/0x2);_0x1b54df['drawText'](_0x1684a2,0x0,_0x3c8637,_0x1b54df['width'],_0x1b54df['fontSize']+0x4,_0x471a0a(0x1d8));};